/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaConnectionFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.constant.ReportType;
import com.humuson.tas.sender.model.push.PushReport;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPushReportService
implements KafkaService<PushReport> {
    private static final Logger log = LoggerFactory.getLogger(AppPushReportService.class);
    private static final String DEV_APPPUSH_REPORT_TOPIC = "dev-report-push";
    private static final String PROD_APPPUSH_REPORT_TOPIC = "prod-report-push";
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 5000L;
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaConnectionFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(PushReport payload) throws JsonProcessingException {
        this.send(payload, true);
    }

    @Override
    public void send(PushReport payload, boolean isProduct) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        String topic = isProduct ? PROD_APPPUSH_REPORT_TOPIC : DEV_APPPUSH_REPORT_TOPIC;
        this.send(topic, data);
    }

    @Override
    public void send(String topic, PushReport payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error : {}", (Object)data);
                } else {
                    log.info("send success data:{}", (Object)data);
                }
            }
        });
    }

    @Override
    public boolean sendSync(PushReport payload) throws Exception {
        return this.sendSync(payload, true);
    }

    @Override
    public boolean sendSync(PushReport payload, boolean isProduct) throws Exception {
        return this.sendSync(payload, isProduct, 5000L);
    }

    @Override
    public boolean sendSync(PushReport payload, boolean isProduct, long timeout) throws Exception {
        String topic = isProduct ? PROD_APPPUSH_REPORT_TOPIC : DEV_APPPUSH_REPORT_TOPIC;
        return this.sendSync(topic, payload, timeout);
    }

    @Override
    public boolean sendSync(String topic, PushReport payload) throws Exception {
        return this.sendSync(topic, payload, 5000L);
    }

    @Override
    public boolean sendSync(String topic, PushReport payload, long timeout) throws Exception {
        try {
            String data = this.mapper.writeValueAsString((Object)payload);
            RecordMetadata recodeMetadata = (RecordMetadata)this.pushProducer.send(new ProducerRecord(topic, (Object)data)).get(5000L, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("topic:{}, partition:{}, checksum:{}", new Object[]{recodeMetadata.topic(), recodeMetadata.partition(), recodeMetadata.checksum()});
            }
            return true;
        }
        catch (Exception e) {
            log.error("send kafka error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AppPushReportService s = new AppPushReportService();
        s.init();
        String json = "{\"APP_GRP_KEY\":\"8772750e-176a-4d81-af2a-364195aea294\",\"UUID\":\"8a399a63-4e39-42b1-b29f-4e198ea99374\",\"TITLE\":\"TAS \uc6f9\ud478\uc2dc \uc774\ubca4\ud2b8\",\"MESSAGE\":\"\ucc28\ud6a8\uc11d \uace0\uac1d\ub2d8! \ubaa8\ubc14\uc77c \uc571 \uc5c6\uc774 \ud478\uc2dc\ub97c \ubc1c\uc1a1\ud560 \uc218 \uc788\ub294 TAS \uc6f9\ud478\uc2dc\ub97c \uccb4\ud5d8\ud558\uc168\uc2b5\ub2c8\ub2e4. \uc774\ubca4\ud2b8 \uc0c1\ud488 \ud655\uc778\ud558\uc138\uc694!\",\"PUSH_IMG_URL\":\"https://img-mkt.tason.com/postman2011/event/seminar_180313/gift_new.png\",\"TTL\":0,\"REQUEST_UID\":\"140524|195|166|953|8eac8f3c-527f-4443-b249-dc78d02aa041|8eac8f3c-527f-4443-b249-dc78d02aa041\",\"REPORT_QUEUE\":\"dev-web-push-report\",\"LANDING_URL\":\"https://tason.com/event/webpush/thanks\"}";
        String json2 = "{\"APP_GRP_KEY\": \"8772750e-176a-4d81-af2a-364195aea294\", \"CUST_ID\":\"1061c5c3-00c5-41fd-b10d-fb0d0209d1fd\", \"ICON_URL\":\"https://img-amc.tason.com/resources/renewal/images/tas-favicon.ico\", \"TITLE\":\"push test\", \"PUSH_IMG_URL\":\"https://media.shilladfs.com/medias/sys_master/images/h4d/hff/11758417739806.jpg\", \"MESSAGE\":\"push msg test\",  \"LANDING_URL\": \"https://www.tason.com\", \"REQUEST_UID\":\"1234567890\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushReport report = new PushReport();
            report.setCustId("tt");
            report.setReportType(ReportType.OPEN.getCode());
            report.setResponseDate("20180430163100");
            report.setRequestUid("TEST1113123132131");
            s.send("dev-app-push-report", report);
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

