package com.humuson.tas.sender.model.push;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.humuson.tas.sender.constant.PushResponse;
import com.humuson.tas.sender.constant.ReportType;

import lombok.Data;

@JsonInclude(Include.NON_NULL)
@Data
public class PushReport implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8359839836953909232L;
	
	private ReportType reportType;
	
	@JsonProperty("CUST_ID")
	private String custId;
	
	@JsonProperty("UUID")
	private String uuid;
	
	private PushResponse pushResponse;
	
	@JsonProperty("RESULT_CD")
	private String resultCd;
	
	@JsonProperty("REPORT_QUEUE")
	private String reportQueue = "";
	
	@JsonProperty("REQUEST_UID")
	private String requestUid;
	
	@JsonProperty("USER_DATA")
	private String userData;
	
	@JsonProperty("RESPONSE_DATE")
	private String responseDate;
	
	@JsonProperty("REPORT_TYPE")
	public String getReportType() {
		return reportType.getCode();
	}
	
	public void setPushResponse(PushResponse pushResponse) {
		this.pushResponse = pushResponse;
		this.resultCd = pushResponse.getStatusCode();
	}
	
	public void setReportType(String reportType) {
		this.reportType = ReportType.findByCode(reportType);
	}
	
	public PushReport(ReportType reportType, String custId, String requestUid, String reportQueue, String userData, PushResponse response) {
		this(reportType, custId, null, requestUid, reportQueue, userData, response);
	}
	
	public PushReport(ReportType reportType, String custId, String uuid, String requestUid, String reportQueue, String userData, PushResponse response) {
		this.reportType = reportType;
		this.custId = custId;
		this.uuid = uuid;
		this.requestUid = requestUid;
		this.reportQueue = !"".equals(reportQueue) ? reportQueue : "";
		this.pushResponse = response;
		this.resultCd = pushResponse.getStatusCode();
		this.userData = userData;
		this.responseDate = System.currentTimeMillis()+"";
	}
	
	public PushReport() {
	}
}
