package com.humuson.tas.sender.model.push;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.humuson.tas.sender.constant.PushResponse;
import com.humuson.tas.sender.constant.ReportType;

import lombok.Data;

@JsonInclude(Include.NON_NULL)
@Data
public class PushPayload {
	
	@JsonProperty("DEVICE")
	private Device device;
	
	@JsonProperty("APP_GRP_KEY")
	private String appGrpKey;
	
	@JsonProperty("RESERVED_DATE")
	private String reservedDate;
	
	@JsonProperty("CUST_ID")
	private String custId;
	
	@JsonProperty("UUID")
	private String uuid;
	
	@JsonProperty("TITLE")
	private String title;
	
	@JsonProperty("MESSAGE")
	private String message;
	
	@JsonProperty("PUSH_IMG_URL")
	private String pushImgUrl;
	
	@JsonProperty("PUSH_KEY")
	private String pushKey;
	
	@JsonProperty("PUSH_VALUE")
	private String pushValue;
	
	@JsonProperty("TTL")
	private int ttl;
	
	@JsonProperty("REQUEST_UID")
	private String requestUid;
	
	@JsonProperty("REPORT_QUEUE")
	private String reportQueue;
	
	@JsonProperty("LANDING_URL")
	private String landingUrl;
	
	@JsonProperty("USER_DATA")
	private String userData;
	
	public PushReport toReport(ReportType reportType,
			PushResponse resultCd) {
		return new PushReport(
				reportType,
				this.custId,
				this.uuid,
				this.requestUid, 
				this.reportQueue,
				this.userData,
				resultCd
				);
	}
}
