package com.humuson.tas.sender.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public abstract class PushResultConsumerGroup implements PushReportListener {

	private final ExecutorService executor;
	final List<PushResultConsumer> consumers = new ArrayList<PushResultConsumer>();
//	private PushReportListener listener;
	
	public PushResultConsumerGroup(String groupId, String topic) {
		this(groupId, topic, 1);
	}
	
	public PushResultConsumerGroup(String groupId, String topic, int numberOfComsumers) {
		executor = Executors.newFixedThreadPool(numberOfComsumers);
		
		for (int i = 0; i < numberOfComsumers; i++) {
			PushResultConsumer consumer = new PushResultConsumer(i, groupId, topic);
			consumer.setReportListener(this);
		    consumers.add(consumer);
		    executor.submit(consumer);
		}
	}
	
	@PostConstruct
	public void init() {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			
			@Override
		    public void run() {
		    		for (PushResultConsumer consumer : consumers) {
		    			consumer.shutdown();
		    		} 
		    		executor.shutdown();
		    		try {
		    			executor.awaitTermination(5000, TimeUnit.MILLISECONDS);
		    		} catch (InterruptedException e) {
		    			log.error("error", e);
		    		}
		    }
		  });
	}
	
	
//	public void setReportListener(PushReportListener listener) {
//		this.listener = listener;
//	}

//	@Override
//	public void result(PushReport report) {
//		if (this.listener != null) {
//			this.listener.result(report);
//		}
//		log.info("push report : {}", report.toString());
//	}
}
