/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaProducerFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.model.push.WebPushPayload;
import java.io.IOException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPushSendService
implements KafkaService<WebPushPayload> {
    private static final Logger log = LoggerFactory.getLogger(WebPushSendService.class);
    private static final String DEV_WEBPUSH_TOPIC = "dev-web-push-request";
    private static final String PROD_WEBPUSH_TOPIC = "prod-web-push-request";
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaProducerFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(WebPushPayload payload) throws JsonProcessingException {
        this.send(payload, true);
    }

    @Override
    public void send(WebPushPayload payload, boolean isProduct) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        String topic = isProduct ? PROD_WEBPUSH_TOPIC : DEV_WEBPUSH_TOPIC;
        this.send(topic, data);
    }

    @Override
    public void send(String topic, WebPushPayload payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(final String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error :{}", (Object)data);
                }
                log.info("send complete:[topic:{}, data:{}]", (Object)topic, (Object)data);
            }
        });
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        WebPushSendService s = new WebPushSendService();
        s.init();
        String json = "{\"APP_GRP_KEY\":\"ed3c1123-2e7f-4616-b9af-f1509962aefb\",\"UUID\":\"8eac8f3c-527f-4443-b249-dc78d02aa041\",\"TITLE\":\"TAS \uc6f9\ud478\uc2dc \uc774\ubca4\ud2b8\",\"MESSAGE\":\"\ucc28\ud6a8\uc11d \uace0\uac1d\ub2d8! \ubaa8\ubc14\uc77c \uc571 \uc5c6\uc774 \ud478\uc2dc\ub97c \ubc1c\uc1a1\ud560 \uc218 \uc788\ub294 TAS \uc6f9\ud478\uc2dc\ub97c \uccb4\ud5d8\ud558\uc168\uc2b5\ub2c8\ub2e4. \uc774\ubca4\ud2b8 \uc0c1\ud488 \ud655\uc778\ud558\uc138\uc694!\",\"PUSH_IMG_URL\":\"https://img-mkt.tason.com/postman2011/event/seminar_180313/gift_new.png\",\"TTL\":0,\"REQUEST_UID\":\"140524|195|166|953|8eac8f3c-527f-4443-b249-dc78d02aa041|8eac8f3c-527f-4443-b249-dc78d02aa041\",\"REPORT_QUEUE\":\"dev-web-push-report\",\"LANDING_URL\":\"https://dev.tason.com/event/webpush/thanks\"}";
        String json2 = "{\"APP_GRP_KEY\": \"8772750e-176a-4d81-af2a-364195aea294\", \"CUST_ID\":\"1061c5c3-00c5-41fd-b10d-fb0d0209d1fd\", \"ICON_URL\":\"https://img-amc.tason.com/resources/renewal/images/tas-favicon.ico\", \"TITLE\":\"push test\", \"PUSH_IMG_URL\":\"https://media.shilladfs.com/medias/sys_master/images/h4d/hff/11758417739806.jpg\", \"MESSAGE\":\"push msg test\",  \"LANDING_URL\": \"https://www.tason.com\", \"REQUEST_UID\":\"1234567890\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            WebPushPayload payload = (WebPushPayload)mapper.readValue(json, WebPushPayload.class);
            payload.setPushKey("l");
            payload.setPushValue("https://jsonlint.com/");
            payload.setReportQueue("dev-web-push-report");
            System.out.println("payload :" + payload.getUuid());
            s.send(payload, false);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

