/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerFactory.class);
    private static Object key = new Object();
    private static volatile Producer<String, String> producer;

    private static Producer<String, String> createProducer() {
        if (producer == null) {
            Properties props = new Properties();
            try {
                props.put("bootstrap.servers", "119.207.76.29:9092,119.207.76.30:9092,119.207.76.31:9092");
                props.put("client.id", "pushpiaKafkaProducer");
                props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                props.put("acks", "all");
                props.put("linger.ms", (Object)100);
                props.put("compression.type", "snappy");
                KafkaProducerFactory.setupRetriesInFlightTimeout(props);
                producer = new KafkaProducer(props);
            }
            catch (Exception e) {
                log.error("Kafka producer config error", (Throwable)e);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Producer<String, String> getProducer() {
        if (producer == null) {
            Object object = key;
            synchronized (object) {
                if (producer == null) {
                    producer = KafkaProducerFactory.createProducer();
                }
            }
        }
        return producer;
    }

    private static void setupRetriesInFlightTimeout(Properties props) {
        props.put("max.in.flight.requests.per.connection", (Object)1);
        props.put("retries", (Object)3);
    }

    private static class UserHashPartitioner
    implements Partitioner {
        private final Set<String> importantUserId = new HashSet<String>();

        public void configure(Map<String, ?> configs) {
        }

        public int partition(String topic, Object objectKey, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
            List partitionInfoList = cluster.availablePartitionsForTopic(topic);
            int partitionCount = partitionInfoList.size();
            int importantPartition = partitionCount - 1;
            int normalPartitionCount = partitionCount - 1;
            String key = (String)objectKey;
            if (this.importantUserId.contains(key)) {
                return importantPartition;
            }
            return Math.abs(key.hashCode()) % normalPartitionCount;
        }

        public void close() {
        }
    }

    private static class CloseSafeProducer<K, V>
    implements Producer<K, V> {
        private final Producer<K, V> delegate;

        CloseSafeProducer(Producer<K, V> delegate) {
            this.delegate = delegate;
        }

        public void close() {
            this.delegate.close();
        }

        public Map<MetricName, ? extends Metric> metrics() {
            return this.delegate.metrics();
        }

        public List<PartitionInfo> partitionsFor(String topic) {
            return this.delegate.partitionsFor(topic);
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
            return this.delegate.send(record);
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
            return this.delegate.send(record, callback);
        }

        public void destroy() {
            this.delegate.close();
        }

        public void flush() {
            this.delegate.flush();
        }

        public void close(long timeout, TimeUnit unit) {
            this.delegate.close(timeout, unit);
        }
    }
}

