/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaProducerFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.model.push.AppPushPayload;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPushSendService
implements KafkaService<AppPushPayload> {
    private static final Logger log = LoggerFactory.getLogger(AppPushSendService.class);
    private static final String DEV_APPPUSH_TOPIC = "dev-app-push-request";
    private static final String PROD_APPPUSH_TOPIC = "prod-app-push-request";
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaProducerFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(AppPushPayload payload) throws JsonProcessingException {
        this.send(payload, true);
    }

    @Override
    public void send(AppPushPayload payload, boolean isProduct) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        String topic = isProduct ? PROD_APPPUSH_TOPIC : DEV_APPPUSH_TOPIC;
        this.send(topic, data);
    }

    @Override
    public void send(String topic, AppPushPayload payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error : {}", (Object)data);
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }
}

