package com.humuson.tas.sender.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class KafkaProducerFactory {
	
	private static Object key = new Object();

	private static volatile Producer<String, String> producer;
	
	private static Producer<String, String> createProducer() {
		if (producer == null) {
			Properties props = new Properties();
			try {
				props.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, "119.207.76.29:9092,119.207.76.30:9092,119.207.76.31:9092");
				props.put(ProducerConfig.CLIENT_ID_CONFIG, "pushpiaKafkaProducer");
				
				props.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringSerializer");
				props.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringSerializer");
//				props.put(ProducerConfig.PARTITIONER_CLASS_CONFIG, UserHashPartitioner.class.getName());
				
				props.put(ProducerConfig.ACKS_CONFIG, "all");
				props.put(ProducerConfig.LINGER_MS_CONFIG, 100);
//				props.put(ProducerConfig.BATCH_SIZE_CONFIG,  16_384 * 4);
				props.put(ProducerConfig.COMPRESSION_TYPE_CONFIG, "snappy");
				
				setupRetriesInFlightTimeout(props);
				
//				producer = new CloseSafeProducer<String, String>(new KafkaProducer<String, String>(props));
				producer = new KafkaProducer<String, String>(props);
			} catch (Exception e) {
				log.error("Kafka producer config error", e);
			}
		}
		
		return producer;
	}
	
	public static Producer<String, String> getProducer() {
		if ( producer == null ) {
			synchronized (key) {
				if ( producer == null ) {
					producer = createProducer();
				}
			}
		}
		return producer;
	}
	
	private static void setupRetriesInFlightTimeout(Properties props) {
        //Only one in-flight messages per Kafka broker connection
        // - max.in.flight.requests.per.connection (default 5)
        props.put(ProducerConfig.MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION,
                1);
        //Set the number of retries - retries
        props.put(ProducerConfig.RETRIES_CONFIG, 3);

        //Request timeout - request.timeout.ms
//        props.put(ProducerConfig.REQUEST_TIMEOUT_MS_CONFIG, 15_000);

        //Only retry after one second.
//        props.put(ProducerConfig.RETRY_BACKOFF_MS_CONFIG, 1_000);
    }
	
	private static class CloseSafeProducer<K, V> implements Producer<K, V> {

		private final Producer<K, V> delegate;

		CloseSafeProducer(Producer<K, V> delegate) {
			this.delegate = delegate;
		}

		@Override
		public void close() {
			delegate.close();
		}

		@Override
		public Map<MetricName, ? extends Metric> metrics() {
			return delegate.metrics();
		}

		@Override
		public List<PartitionInfo> partitionsFor(String topic) {
			return delegate.partitionsFor(topic);
		}

		@Override
		public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
			return delegate.send(record);
		}

		@Override
		public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
			return delegate.send(record, callback);
		}
		
		@SuppressWarnings("unused")
		public void destroy() {
			delegate.close();
		}

		@Override
		public void flush() {
			delegate.flush();
		}

		@Override
		public void close(long timeout, TimeUnit unit) {
			delegate.close(timeout, unit);
		}
	}
	
	private static class UserHashPartitioner implements Partitioner {
		
		private final Set<String> importantUserId;
		
		public UserHashPartitioner() {
			importantUserId = new HashSet<String>();
		}
		
		@Override
		public void configure(Map<String, ?> configs) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public int partition(String topic, Object objectKey, byte[] keyBytes, Object value, byte[] valueBytes,
				Cluster cluster) {
			final List<PartitionInfo> partitionInfoList =
	                cluster.availablePartitionsForTopic(topic);
	        final int partitionCount = partitionInfoList.size();
	        final int importantPartition = partitionCount -1;
	        final int normalPartitionCount = partitionCount -1;

	        final String key = ((String) objectKey);

	        if (importantUserId.contains(key)) {
	            return importantPartition;
	        } else {
	            return Math.abs(key.hashCode()) % normalPartitionCount;
	        }
		}

		@Override
		public void close() {
			// TODO Auto-generated method stub
		}
	}
}
