/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.humuson.tas.sender.client.PushReportListener;
import com.humuson.tas.sender.client.PushResultConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PushResultConsumerGroup
implements PushReportListener {
    private static final Logger log = LoggerFactory.getLogger(PushResultConsumerGroup.class);
    private final ExecutorService executor;
    final List<PushResultConsumer> consumers = new ArrayList<PushResultConsumer>();

    public PushResultConsumerGroup(String groupId, String topic) {
        this(groupId, topic, 1);
    }

    public PushResultConsumerGroup(String groupId, String topic, int numberOfComsumers) {
        this.executor = Executors.newFixedThreadPool(numberOfComsumers);
        for (int i = 0; i < numberOfComsumers; ++i) {
            PushResultConsumer consumer = new PushResultConsumer(i, groupId, topic);
            consumer.setReportListener(this);
            this.consumers.add(consumer);
            this.executor.submit(consumer);
        }
    }

    @PostConstruct
    public void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (PushResultConsumer consumer : PushResultConsumerGroup.this.consumers) {
                    consumer.shutdown();
                }
                PushResultConsumerGroup.this.executor.shutdown();
                try {
                    PushResultConsumerGroup.this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.error("error", (Throwable)e);
                }
            }
        });
    }
}

