/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaConnectionFactory;
import com.humuson.tas.sender.client.PushReportListener;
import com.humuson.tas.sender.model.push.PushReport;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushResultConsumer
implements Closeable,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(PushResultConsumer.class);
    private static final String APP_PUSH_REPORT_TOPIC = "prod-report-push";
    private static final String DEFAULT_GROUP_ID = "tas-sender-client-01";
    private Consumer<String, String> consumer;
    private final ObjectMapper mapper;
    private PushReportListener listener;
    private final String topic;
    private final String groupId;

    public PushResultConsumer() {
        this(1, APP_PUSH_REPORT_TOPIC, DEFAULT_GROUP_ID);
    }

    public PushResultConsumer(int threadNumber, String topic, String groupId) {
        this.topic = topic;
        this.groupId = groupId;
        this.mapper = new ObjectMapper();
        log.info("Push result consumer init [topic:{}, groupId:{}", (Object)topic, (Object)groupId);
    }

    public void setReportListener(PushReportListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        this.consumer = KafkaConnectionFactory.createConsumer(this.topic, this.groupId);
        while (true) {
            ConsumerRecords records;
            if ((records = this.consumer.poll(1000L)).count() == 0) {
                continue;
            }
            try {
                this.process((ConsumerRecords<String, String>)records);
                continue;
            }
            finally {
                this.consumer.commitAsync();
                continue;
            }
            break;
        }
    }

    public void process(ConsumerRecords<String, String> list) {
        ArrayList<PushReport> reportList = new ArrayList<PushReport>();
        for (ConsumerRecord record : list) {
            if (log.isDebugEnabled()) {
                log.debug("partition:{}, offset:{}, value:{}", new Object[]{record.partition(), record.offset(), record.value()});
            }
            try {
                PushReport report = (PushReport)this.mapper.readValue((String)record.value(), PushReport.class);
                reportList.add(report);
            }
            catch (Exception e) {
                log.error("consumer parse error :[{}]", record.value(), (Object)e);
            }
        }
        if (this.listener != null) {
            this.listener.result(reportList);
        }
    }

    @Override
    public void close() throws IOException {
        this.consumer.close();
    }

    public void shutdown() {
        this.consumer.wakeup();
    }
}

