/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaConnectionFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.model.push.PushReport;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPushReportService
implements KafkaService<PushReport> {
    private static final Logger log = LoggerFactory.getLogger(AppPushReportService.class);
    private static final String DEV_APPPUSH_REPORT_TOPIC = "dev-report-push";
    private static final String PROD_APPPUSH_REPORT_TOPIC = "prod-report-push";
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 5000L;
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaConnectionFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(PushReport payload) throws JsonProcessingException {
        this.send(payload, true);
    }

    @Override
    public void send(PushReport payload, boolean isProduct) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        String topic = isProduct ? PROD_APPPUSH_REPORT_TOPIC : DEV_APPPUSH_REPORT_TOPIC;
        this.send(topic, data);
    }

    @Override
    public void send(String topic, PushReport payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error : {}", (Object)data);
                }
            }
        });
    }

    @Override
    public boolean sendSync(PushReport payload) throws Exception {
        return this.sendSync(payload, true);
    }

    @Override
    public boolean sendSync(PushReport payload, boolean isProduct) throws Exception {
        return this.sendSync(payload, isProduct, 5000L);
    }

    @Override
    public boolean sendSync(PushReport payload, boolean isProduct, long timeout) throws Exception {
        String topic = isProduct ? PROD_APPPUSH_REPORT_TOPIC : DEV_APPPUSH_REPORT_TOPIC;
        return this.sendSync(topic, payload, isProduct, timeout);
    }

    @Override
    public boolean sendSync(String topic, PushReport payload, boolean isProduct, long timeout) throws Exception {
        try {
            String data = this.mapper.writeValueAsString((Object)payload);
            RecordMetadata recodeMetadata = (RecordMetadata)this.pushProducer.send(new ProducerRecord(topic, (Object)data)).get(5000L, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("topic:{}, partition:{}, checksum:{}", new Object[]{recodeMetadata.topic(), recodeMetadata.partition(), recodeMetadata.checksum()});
            }
            return true;
        }
        catch (Exception e) {
            log.error("send kafka error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }
}

