package com.humuson.tas.sender.constant;

public enum PushResponse {
	PENDING("9999", "Pendding"),
	TODAY_SEND_FILTER("9000", "TODAY_SEND_FILTER"),
	CHANGED_SUCCESSFUL("0000", "CHANGED_SUCCESSFUL"),
	SUCCESSFUL("1000", "Successful"),
	UNKNOWN_FAIL("4000", "UNKNOWN_FAIL"),
	MSG_DENY("4100", "MSG_DENY"),
	DENY_PUSH("4400", "DENY_PUSH"),
	DENY_MKT_PUSH("4401", "DENY_MKT_PUSH"),
	DENY_APP_VERSION("4500", "DENY_APP_VERSION"),
	NO_PMS_USER("5000", "NO_PMS_USER"),
	WRONG_PARAM("6000", "WRONG_PARAM"),
	PRIVATE_FEEDBACK_TIMEOUT("7000", "PRIVATE_FEEDBACK_TIMEOUT"),
	TTL_EXPIRED("7500", "TTL_EXPIRED"),
	NO_SEND("8000", "NO_SEND"),
	PRIVATE_SERVER_ERROR("8500", "PRIVATE_SERVER_ERROR"),
	SENDING("3000", "SENDING"),
	PRIVATE_SEND_FAILED("3101", "PRIVATE_SEND_FAILED"),
	PRIVATE_UNACTIVED_TOKEN("3102", "PRIVATE_UNACTIVED_TOKEN"),
	PRIVATE_TIMEOUT("3103", "PRIVATE_TIMEOUT"),
	PRIVATE_REJECTED("3104", "PRIVATE_REJECTED"),
	PRIVATE_UNKNOWN_ERROR("3105", "PRIVATE_UNKNOWN_ERROR"),
	PRIVATE_INVALID_TOKEN("3106", "PRIVATE_INVALID_TOKEN"),
	
	// APNS
	NO_EXIST_CERTIFICATION("1100", "NO_EXIST_CERTIFICATION"),
	APNS_DUPLICATE_DEVICE_EXCEPTION("1001", "DuplicateDeviceException"),
	APNS_INVALID_DEVICE_TOKEN_FORMAT_EXCEPTION("1002", "InvalidDeviceTokenFormatException"),
	APNS_NULL_DEVICE_TOKEN_EXCEPTION("1003", "NullDeviceTokenException"),
	APNS_NULL_ID_EXCEPTION("1004", "NullIdException"),
	APNS_UNKNOWN_DEVICE_EXCEPTION("1005", "UnknownDeviceException"),
	APNS_COMMUNICATION_EXCEPTION	("1006", "APNS_NULL_DEVICE_TOKEN_EXCEPTION"),
	APNS_CONNECTION_ERROR("1007", "APNS_NULL_DEVICE_TOKEN_EXCEPTION"),
	APNS_MESSAGE_IS_EMPTY("1008", "APNS_NULL_DEVICE_TOKEN_EXCEPTION"),
	APNS_PAYLOAD_MAX_SIZE_EXCEEDED_EXCEPTION("1009", "APNS_NULL_DEVICE_TOKEN_EXCEPTION"),
	APNS_UNKNOWN_ERROR("1111", "APNS_NULL_DEVICE_TOKEN_EXCEPTION"),
	
	APNS_BAD_COLLAPSE_ID_ERROR("1112", "BadCollapseId"),
	APNS_BAD_DEVICE_TOKEN_ERROR("1113", "BadDeviceToken"),
	APNS_BAD_EXPIRATION_DATE_ERROR("1114", "BadExpirationDate"),
	APNS_BAD_MESSAGE_ID_ERROR("1115", "BadMessageId"),
	APNS_BAD_PRIORITY_ERROR("1116", "BadPriority"),
	APNS_BAD_TOPIC_ERROR("1117", "BadTopic"),
	APNS_DEVICE_TOKEN_NOT_FOR_TOPIC_ERROR("1118", "DeviceTokenNotForTopic"),
	APNS_DUPLICATE_HEADERS_ERROR("1119", "DuplicateHeaders"),
	APNS_IDLE_TIMEOUT_ERROR("1120", "IdleTimeout"),
	APNS_MISSING_DEVICETOKEN_ERROR("1121", "MissingDeviceToken"),
	APNS_MISSING_TOPIC_ERROR("1122", "MissingTopic"),
	APNS_PAYLOAD_EMPTY_ERROR("1123", "PayloadEmpty"),
	APNS_TOPIC_DISALLOWED_ERROR("1124", "TopicDisallowed"),
	APNS_BAD_CERTIFICATE_ERROR("1125", "BadCertificate"),
	APNS_BAD_CERTIFICATE_ENVIRONMENT_ERROR("1126", "BadCertificateEnvironment"),
	APNS_EXPIRED_PROVIDER_TOKEN_ERROR("1127", "ExpiredProviderToken"),
	APNS_FORBIDDEN_ERROR("1128", "Forbidden"),
	APNS_INVALID_PROVIDERTOKEN_ERROR("1129", "InvalidProviderToken"),
	APNS_MISSING_PROVIDERTOKEN_ERROR("1130", "MissingProviderToken"),
	APNS_BADPATH_ERROR("1131", "BadPath"),
	APNS_METHOD_NOT_ALLOWED_ERROR("1132", "MethodNotAllowed"),
	APNS_UNREGISTERED_ERROR("1133", "Unregistered"),
	APNS_PAYLOAD_TOO_LARGE_ERROR("1134", "PayloadTooLarge"),
	APNS_TOOMANY_PROVIDER_TOKEN_UPDATES_ERROR("1135", "TooManyProviderTokenUpdates"),
	APNS_TOO_MANY_REQUESTS_ERROR("1136", "TooManyRequests"),
	APNS_INTERNAL_SERVERERROR_ERROR("1137", "InternalServerError"),
	APNS_SERVICE_UNAVAILABLE_ERROR("1138", "ServiceUnavailable"),
	APNS_SHUTDOWN_ERROR("1139", "Shutdown"),
	
	
	
	// C2DM
	ERROR_QUOTA_EXCEEDED("2001", "QuotaExceeded"),
	ERROR_DEVICE_QUOTA_EXCEEDED("2002", "DeviceQuotaExceeded"),
	ERROR_MISSING_REGISTRATION ( "2003", "MissingRegistration"),
	ERROR_INVALID_REGISTRATION ("2004", "InvalidRegistration"),
	ERROR_MISMATCH_SENDER_ID ( "2005", "MismatchSenderId"),
	ERROR_NOT_REGISTERED ( "2006", "NotRegistered"),
	ERROR_MESSAGE_TOO_BIG ( "2007", "MessageTooBig"),
	ERROR_MISSING_COLLAPSE_KEY ( "2008", "MissingCollapseKey"),
	ERROR_UNAVAILABLE ( "2009", "Unavailable"),
	
	ERROR_BAD_ACK("2010", "BAD_ACK"),
	ERROR_BAD_REGISTRATION ("2004", "BadRegistration"),
	ERROR_DEVICE_UNREGISTERED("2006", "DeviceUnregistered"),
	ERROR_INTERNAL_SERVER_ERROR("2009", "InternalServerError"),
	ERROR_INVALID_JSON("2012", "InvalidJson"),
	ERROR_DEVICE_MESSAGE_RATE_EXCEEDE("2001", "DeviceMessageRateExceeded"),
	ERROR_SERVICE_UNAVAILABLE("2009", "Unavailable"),
	ERROR_TOPICS_MESSAGE_RATE_EXCEEDED("2011", "TopicsMessageRateExceeded"),
	ERROR_CONNECTION_DRAINING("2009", "ConnectionDraining"),
	//
	MASTER_FLAG_CHANGED("3201", "masterFlagChanged"),
	CUST_ID_CHANGED("3202", "CustIdChanged"),
	ETIQUETTE_TIME( "3203", "DeviceUnregistered");
	
	
	private String statusCode;    
    private String reasonPhrase;
    
    PushResponse(String statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }
    
    public String getStatusCode() {
        return statusCode;
    }
    
    public String getReasonPhrase() {
        return reasonPhrase;
    }
    
    public static PushResponse findReasonPhrase(String reasonPhrase) {
        for( PushResponse error : values() ) {
            if (error.getReasonPhrase().equals(reasonPhrase) ) {
               return error;
            }
        }
        return null;
    }
    
    public static PushResponse findStatusByCode( String statusCode ) {
        for( PushResponse error : values() ) {
            if ( error.getStatusCode().equals(statusCode) ) {
               return error;
            }
        }
        return null;
    }
}
