package com.humuson.tas.sender.model.push;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonObject;

import lombok.Data;
import lombok.EqualsAndHashCode;

@JsonInclude(Include.NON_NULL)
@EqualsAndHashCode(callSuper=false)
@Data
public class AppPushPayload extends PushPayload {
	
	private int grpId;
	
	private String topic;
	
	@JsonProperty("MSG_ID")
	private String msgId;
	
	@JsonProperty("MSG_GRP_CD")
	private String msgGrpCd;
	
	@JsonProperty("MSG_TYPE")
	private String msgType = "T";
	
	@JsonProperty("INAPP_CONTENT")
	private String inappContent;
	
	@JsonProperty("RICH_CONTENT")
	private String richContent;
	
	@JsonProperty("ETC1")
	private String etc1;
	
	@JsonProperty("ETC2")
	private String etc2;
	
	@JsonProperty("ETC3")
	private String etc3;
	
	private String notiFlag;
	private String msgTable;
	private String sound;
	private String data; 
	
	public String getData() {
		if ((this.getPushKey() != null && !"".equals(this.getPushKey())) 
				&& (this.getPushValue() != null && !"".equals(this.getPushValue()))) {
			
			JsonObject json = new JsonObject();
			json.addProperty(this.getPushKey(), this.getPushValue());
			
			this.data = json.toString();
		}
		return this.data;
	}
}
