package com.humuson.tas.sender.constant;


/**
 * API 에러 코드를 명시한 Enum 객체이다.
 *
 */
public enum Status {

	
	OK("000", "OK", HttpStatus.OK),
	
    AuthenticationFail("E011", "Authentication fail", HttpStatus.UNAUTHORIZED),
    ApiKeyIsNotValid("E012", "Api Key is not valid", HttpStatus.UNAUTHORIZED),
    UserAlreadyExist("E013", "user already exist", HttpStatus.UNAUTHORIZED),
    InvalidToken("E014", "Invalid Token", HttpStatus.UNAUTHORIZED),
    UserNotFound("E015", "user not found", HttpStatus.UNAUTHORIZED),
    
    UrlNotFound("E021", "URL not found", HttpStatus.NOT_FOUND),
    ParamNotValid("E031", "param not valid", HttpStatus.BAD_REQUEST),
    NoRegisteredValue("E041", "no registered value", HttpStatus.BAD_REQUEST),
    NoSuchTypes("E042", "no such types", HttpStatus.BAD_REQUEST),
    
    /**
     * 요청한 콘텐츠 타입이 잘못된 경우
     */
    ContentTypeError("E051", "content type error", HttpStatus.BAD_REQUEST),
    /**
     * json 요청 파싱 에러.
     */
    JsonParseError("E061", "json parse error", HttpStatus.BAD_REQUEST),
    /**
     * 요청값이 읽어 들이지 못하는 메시지인 경우 (메시지 형식이 잘못된 경우) 
     */
    NotReadableRequest("E071", "not readable request", HttpStatus.BAD_REQUEST),
    
    /**
     * 지원되지 않는 메소드 형태인 경우. POST,PUT,GET,UPDATE 형식중 알맞지 않은 메소드 형식을 사용한 경우 
     */
    RequestMethodNotSupported("E081", "request method not supported", HttpStatus.METHOD_NOT_ALLOWED),
    
    /**
     * 접근 거부
     */
    AccessDenied("E091", "access denied", HttpStatus.FORBIDDEN),
    
    AppNotRegistered("E101", "App Not Registered", HttpStatus.BAD_REQUEST),
    
    SiteNotRegistered("E102", "Site Not Registered", HttpStatus.BAD_REQUEST),
    
    AudienceUserUploadError("E201","audience upload error",HttpStatus.INTERNAL_SERVER_ERROR),
    
    PostmanApiError("E301","poatman api error",HttpStatus.INTERNAL_SERVER_ERROR),
    PushpiaApiError("E301","pushpia api error",HttpStatus.INTERNAL_SERVER_ERROR),
    
    EncryptError("E401", "encrypt error", HttpStatus.INTERNAL_SERVER_ERROR),
    DecryptError("E402", "decrypt error", HttpStatus.INTERNAL_SERVER_ERROR),
    
    AlreadyExist("E901", "already exist", HttpStatus.BAD_REQUEST),
    
    /**
     * 기타 에러
     */
    ServerError("E999", "server error", HttpStatus.INTERNAL_SERVER_ERROR);
    
    private String statusCode;    
    private String reasonPhrase;
    private HttpStatus httpStatus;
    
    Status(String statusCode, String reasonPhrase, HttpStatus httpStatus) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.httpStatus = httpStatus;
    }
    
    public String getStatusCode() {
        return statusCode;
    }
    
    public String getReasonPhrase() {
        return reasonPhrase;
    }
    
    public HttpStatus getHttpStatus(){
        return httpStatus;
    }
    
    public static Status findStatusByCode( String statusCode ) {
        for( Status error : values() ) {
            if ( error.getStatusCode().equals(statusCode) ) {
               return error;
            }
        }
        return null;
    }
    
    public static HttpStatus findHttpStatusByCode( String errCode ) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        for( Status error : values() ) {
            if ( error.getStatusCode().equals(errCode) ) {
               status = error.getHttpStatus();
               break;
            }
        }
        return status;        
    }
    
}
