package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.humuson.tas.sender.model.push.PushPayload;

public interface KafkaService<T extends PushPayload> {

	void init();
	
	boolean sendSync(final T payload) throws Exception;
	
	boolean sendSync(final T payload, boolean isProduct) throws Exception;
	
	boolean sendSync(final T payload, boolean isProduct, long timeout) throws Exception;
	
	boolean sendSync(final String topic, final T payload, boolean isProduct, long timeout) throws Exception;
	
	void send(final T payload) throws JsonProcessingException;
	
	void send(final T payload, boolean isProduct) throws JsonProcessingException;
	
	void send(final String topic, final String data);
	
	void send(final String topic, final T payload) throws JsonProcessingException;
	
	void close();
}
