/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaProducerFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.model.push.WebPushPayload;
import java.io.IOException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPushSendService
implements KafkaService<WebPushPayload> {
    private static final Logger log = LoggerFactory.getLogger(WebPushSendService.class);
    private static final String DEFAULT_TOPIC = "dev-web-push-request";
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaProducerFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(WebPushPayload payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(DEFAULT_TOPIC, data);
    }

    @Override
    public void send(String topic, WebPushPayload payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(final String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error :{}", (Object)data);
                }
                log.info("send complete:[topic:{}, data:{}]", (Object)topic, (Object)data);
            }
        });
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        WebPushSendService s = new WebPushSendService();
        s.init();
        String json = "{\"APP_GRP_KEY\": \"B2B-WEB-APP-TEST\", \"UUID\":\"bfba897e-787e-440c-958c-3a6390b4f6d4\", \"TITLE\":\"push test\", \"MESSAGE\":\"push msg test\", \"LANDING_URL\": \"https://www.tason.com\", \"REQUEST_UID\":\"1234567890\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            WebPushPayload payload = (WebPushPayload)mapper.readValue(json, WebPushPayload.class);
            System.out.println("payload :" + payload.getUuid());
            s.send(payload);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

