/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.entityMap.propertyeditors;

import com.humuson.tms.common.util.StringUtils;
import java.beans.PropertyEditorSupport;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;

public class CustomTimeEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;

    public CustomTimeEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText(text)) {
            this.setValue(null);
        } else {
            try {
                this.setValue(new Time(this.dateFormat.parse(text).getTime()));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getAsText() {
        Time value = (Time)this.getValue();
        return value != null ? this.dateFormat.format(value) : "";
    }
}

