/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class NumberUtils {
    private NumberUtils() {
    }

    public static int divideCeil(int value, int divide) {
        return new Double(Math.ceil((double)value / (double)divide)).intValue();
    }

    public static int divideCeil(int value, double divide) {
        return new Double(Math.ceil((double)value / divide)).intValue();
    }

    public static int divideFloor(int value, int divide) {
        return new Double(Math.floor((double)value / (double)divide)).intValue();
    }

    public static int divideFloor(int value, double divide) {
        return new Double(Math.floor((double)value / divide)).intValue();
    }

    public static boolean isNumeric(String text) {
        if (text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (i == 0 && text.substring(i, i + 1).equals("-") || text.substring(i, i + 1).compareTo("0") >= 0 && text.substring(i, i + 1).compareTo("9") <= 0 || text.substring(i, i + 1).equals(".")) continue;
            return false;
        }
        return true;
    }

    public static String getDecimal(String strSrc, int len) {
        int length = strSrc.length();
        int iDec = strSrc.indexOf(46);
        StringBuffer convert = new StringBuffer();
        convert.append(iDec < 0 ? strSrc : strSrc.substring(0, iDec));
        if (iDec < 0) {
            iDec = length;
        }
        for (int i = 1; i <= len; ++i) {
            if (i == 1) {
                convert.append(".");
            }
            convert.append(i + iDec < length ? strSrc.charAt(i + iDec) : (char)'0');
        }
        return convert.toString();
    }

    public static String getDecimal(double dNumber, int len) {
        return NumberUtils.getDecimal(Double.toString(dNumber), len);
    }

    public static double getRandom(int minValue, int maxValue) {
        double value = Math.random() * (double)maxValue + (double)minValue;
        return value;
    }

    public static int getRandomInt() {
        return NumberUtils.getRandomInt(0, 100);
    }

    public static int getRandomInt(int minValue, int maxValue) {
        double value = NumberUtils.getRandom(minValue, maxValue);
        String str = Double.toString(value);
        int index = str.indexOf(".");
        str = str.substring(0, index);
        return Integer.parseInt(str);
    }

    public static String maskComma(String src, int pos) {
        if (src == null || src.length() == 0) {
            return "";
        }
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(',');
        df.setGroupingSize(pos);
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= pos * 7; ++i) {
            if (i % pos == 0 && i != pos * 7) {
                sb.append("#").append(",");
                continue;
            }
            sb.append("#");
        }
        sb.append(".######");
        df.applyPattern(sb.toString());
        df.setDecimalFormatSymbols(dfs);
        String resultValue = df.format(Double.parseDouble(src)).toString();
        return resultValue;
    }

    public static String maskComma(long amt, int pos) {
        return NumberUtils.maskComma(new Long(amt).toString(), pos);
    }

    public static String maskComma(double amt, int pos) {
        return NumberUtils.maskComma(new Double(amt).toString(), pos);
    }

    public static String maskComma(String src) {
        return NumberUtils.maskComma(src, 3);
    }

    public static String maskComma(long amt) {
        return NumberUtils.maskComma(new Long(amt).toString(), 3);
    }

    public static String maskComma(double amt) {
        return NumberUtils.maskComma(new Double(amt).toString(), 3);
    }

    public static String removeComma(String src) {
        String resultValue = "";
        for (int i = 0; i < src.length(); ++i) {
            char temp = src.charAt(i);
            if (temp == ',') continue;
            resultValue = resultValue + temp;
        }
        return resultValue;
    }

    public static float round(float f, int len, int round_type) {
        float retval = 0.0f;
        try {
            retval = BigDecimal.valueOf(f).setScale(len, round_type).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retval;
    }

    public static float division(float son, float mother) {
        float retval = 0.0f;
        if (mother == 0.0f) {
            retval = 0.0f;
        } else {
            retval = son / mother;
            retval = NumberUtils.round(retval, 2, 4);
        }
        return retval;
    }

    public static double getPercentage(double numerator, double denominator) {
        if (denominator == org.apache.commons.lang3.math.NumberUtils.DOUBLE_ZERO) {
            return denominator;
        }
        return numerator / denominator * 100.0;
    }

    public static double getPercentage(double numerator, double denominator, int position) {
        double value = NumberUtils.getPercentage(numerator, denominator);
        double _position = Math.pow(10.0, position);
        return (double)Math.round(value * _position) / _position;
    }

    public static void main(String[] args) {
        String sSrc = "123456789012.1234567890123";
        long dTest = 123456L;
        double f = 10.12345;
    }
}

