/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertiesPersister;

public class DecryptPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    Logger logger = LoggerFactory.getLogger(DecryptPropertyPlaceholderConfigurer.class);
    private Resource[] locations;
    private PropertiesPersister propertiesPersister;
    private String fileEncoding = "utf-8";
    private boolean ignoreResourceNotFound = false;

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource location = this.locations[i];
                try (InputStream is = null;){
                    is = location.getInputStream();
                    this.propertiesPersister.load(props, (Reader)new InputStreamReader(is, this.fileEncoding));
                    continue;
                }
            }
        }
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister;
    }
}

