package com.humuson.tms.entityMap.propertyeditors;


public class CustomBooleanEditor extends org.springframework.beans.propertyeditors.CustomBooleanEditor {

	/** The Constant VALUE_Y. */
	public static final String VALUE_Y = "Y";

	/** The Constant VALUE_N. */
	public static final String VALUE_N = "N";

	/**
	 * Instantiates a new custom boolean editor.
	 *
	 * @param allowEmpty the allow empty
	 */
	public CustomBooleanEditor(boolean allowEmpty) {
		super(allowEmpty);
	}

	/**
	 * Instantiates a new custom boolean editor.
	 *
	 * @param trueString the true string
	 * @param falseString the false string
	 * @param allowEmpty the allow empty
	 */
	public CustomBooleanEditor(String trueString, String falseString, boolean allowEmpty) {
		super(trueString, falseString, allowEmpty);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.springframework.beans.propertyeditors.CustomBooleanEditor#setAsText(java.lang.String)
	 */
	@Override
	public void setAsText(String text) throws IllegalArgumentException {
		try {
			super.setAsText(text);
		} catch (IllegalArgumentException e) {
			String input = (text != null ? text.trim() : null);
			if (input.equalsIgnoreCase(VALUE_Y)) {
				setValue(Boolean.TRUE);
			} else if (input.equalsIgnoreCase(VALUE_N)) {
				setValue(Boolean.FALSE);
			} else {
				throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
			}
		}
	}
}
