/*
 * @(#)XmlWriter.java            2004. 10. 29.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package com.humuson.tms.common.xml;

import java.io.OutputStream;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Class description :
 * 
 * @version		1.1
 * @author 		dragon
 *
 */
public class XmlWriter {
	
	
	private static final byte[] __NEW_LINE = System.getProperty("line.separator").getBytes();
	private static final byte[] __TAB = "\t".getBytes();
	private static final byte[] __TAG_OPEN = "<".getBytes();
	private static final byte[] __END_TAG_OPEN = "</".getBytes();
	private static final byte[] __TAG_CLOSE = ">".getBytes();
	private static final byte[] __NO_CHILD_TAG_CLOSE = "/>".getBytes();
	private static final byte[] __ATTR_OPEN = "=\"".getBytes();
	private static final byte[] __ATTR_CLOSE = "\"".getBytes();
	private static final byte[] __BLANK = " ".getBytes();
	
	private static final byte[] __PROCESSING_INSTRUCTION_NODE_OPEN = "<?".getBytes();
	private static final byte[] __PROCESSING_INSTRUCTION_NODE_CLOSE = "?>".getBytes();
	
	private static final byte[] __N_PERCENT = "&".getBytes();
	private static final byte[] __SEMICOLON = ";".getBytes();

	private static final byte[] __CDATA_OPEN = "<![CDATA[".getBytes();
	private static final byte[] __CDATA_CLOSE = "]]>".getBytes();
	
	private String PRINTWRITER_ENCODING = "euc-kr";
	private boolean canonical  = false;
	private OutputStream STREAM = null;
	private String OUT_CHARSET = null;
	private String DTDFile = null;
	
	private StringBuffer __INNER_WORK_BUFFER = null;
	
	/** Creates new XMLWriter */
	public XmlWriter() throws Exception {
		this.canonical = false;
		__INNER_WORK_BUFFER = new StringBuffer( 256 );
	}
	
	public void outResult(
			OutputStream __STREAM, 
			String __OUT_CHARSET,Document myDoc,
			String df ) 
		throws Exception {
			
		this.DTDFile = df;
		this.STREAM = __STREAM;
		this.OUT_CHARSET = __OUT_CHARSET;
		println("<?xml version=\"1.0\" encoding=\""+ getWriterEncoding() + "\"?>");
		
		Node node = myDoc.getFirstChild();
		
		if( node.getNodeType() == Node.ELEMENT_NODE ){
			println("<!DOCTYPE " + (( Element )node).getTagName() + " SYSTEM \"" + DTDFile + "\">");
		}
		print( myDoc , 0 );
	}
	
	public void setEncoding( String enc ) {
		
		this.PRINTWRITER_ENCODING = enc;
	}
	
	public void setCanonical( boolean can ) {
		
		this.canonical = can;
	}
	
	private Attr[] sortAttributes(NamedNodeMap attrs) {
		
		int len = (attrs != null) ? attrs.getLength() : 0;
		
		Attr array[] = new Attr[len];
		
		for ( int i = 0; i < len; i++ ) {
			array[i] = (Attr)attrs.item(i);
		}
		return(array);
		
	}
	
	private void println( String s ) throws Exception {
		
		print( s );
		newLine();
	}
	
	private void print( String s ) throws Exception {
		
		print( s.getBytes( this.OUT_CHARSET ) );
	}
	
	private void print( byte[] source ) throws Exception {
		
		this.STREAM.write( source );
	}
	
	private void newLine() throws Exception {
		
		print( __NEW_LINE );
		this.STREAM.flush();
	}
	
	private void print(Node node, int depth) throws Exception {
		
		// is there anything to do?
		if ( node == null ) {
			return;
		}
		
		int type = node.getNodeType();
		
		boolean __HAS_CHILD__ = false;
		
		switch ( type ) {
			// print document
			
			case Node.DOCUMENT_NODE: {
				NodeList children = node.getChildNodes();
				
				for ( int iChild = 0; iChild < children.getLength(); iChild++ ) {
					print(children.item(iChild),depth);
				}
				
				this.STREAM.flush();
				break;
			}
			
			case Node.DOCUMENT_TYPE_NODE: {
				println("<!DOCTYPE " + ((DocumentType)node).getName() + " SYSTEM \"" + DTDFile + "\">");
				break;
			}
			
			// print element with attributes
			case Node.ELEMENT_NODE: {
				//print("type ELEMENT_NODE:" + type);
				for( int k = 0 ; k < depth ; k++ ) {
					print( __TAB );
				}
				
				print( __TAG_OPEN );
				print(node.getNodeName());
				Attr attrs[] = sortAttributes(node.getAttributes());
				//Attr attrs[] = node.getAttributes();
				
				for ( int i = 0; i < attrs.length; i++ ) {
					Attr attr = attrs[i];
					print( __BLANK );
					print(attr.getNodeName());
					print( __ATTR_OPEN );
					print(normalize(attr.getNodeValue()));
					print( __ATTR_CLOSE );
				}
				
				NodeList children = node.getChildNodes();
				
				if ( children != null ) {
					int len = children.getLength();
					if( len > 0 ){
						__HAS_CHILD__ = true;
						print( __TAG_CLOSE );
						this.newLine();
						for ( int i = 0; i < len; i++ ) {
							print(children.item(i),depth + 1);
						}
					}
					else{
						__HAS_CHILD__ = false;
						print( __NO_CHILD_TAG_CLOSE );
						this.newLine();
					}
				}
				
				break;
			}
			
			// handle entity reference nodes
			case Node.ENTITY_REFERENCE_NODE: {
				//print("type ENTITY_REFERENCE_NODE:" + type);
				
				if ( canonical ) {
					NodeList children = node.getChildNodes();
					if ( children != null ) {
						int len = children.getLength();
						for ( int i = 0; i < len; i++ ) {
							print(children.item(i),depth + 1);
						}
					}
				}
				else {
					print( __N_PERCENT );
					print(node.getNodeName());
					print( __SEMICOLON );
				}
				break;
			}
			
			// print cdata sections
			case Node.CDATA_SECTION_NODE: {
				//print("type CDATA_SECTION_NODE:" + type);
				for( int k = 0 ; k < depth ; k++ ) {
					print( __TAB );
				}
				
				if ( canonical ) {
					print(normalize(node.getNodeValue()));
				}
				else {
					print( __CDATA_OPEN );
					print(node.getNodeValue());
					print( __CDATA_CLOSE );
					this.newLine();
				}
				break;
			}
			
			// print text
			case Node.TEXT_NODE: {
				//print("type TEXT_NODE:" + type);
				
				String nodeValue = node.getNodeValue();
				
				if( nodeValue.trim().length() == 0 ) break;
				
				for( int k = 0 ; k < depth ; k++ ) {
					print( __TAB );
				}
				print(normalize(nodeValue));
				this.newLine();
				break;
			}
			
			// print processing instruction
			case Node.PROCESSING_INSTRUCTION_NODE: {
				//print("type PROCESSING_INSTRUCTION_NODE:" + type);
				for( int k = 0 ; k < depth ; k++ ) {
					print( __TAB );
				}
				print( __PROCESSING_INSTRUCTION_NODE_OPEN );
				print(node.getNodeName());
				String data = node.getNodeValue();
				if ( data != null && data.length() > 0 ) {
					print( __BLANK );
					print(data);
				}
				print( __PROCESSING_INSTRUCTION_NODE_CLOSE );
				this.newLine();
				break;
			}
			
			default:
				//println("default:" + type);
				
		}
		
		if ( type == Node.ELEMENT_NODE && __HAS_CHILD__ ) {
			for( int k = 0 ; k < depth ; k++ ) {
				print( __TAB );
			}
			print( __END_TAG_OPEN );
			print(node.getNodeName());
			print( __TAG_CLOSE );
			this.newLine();
		}
		
		this.STREAM.flush();
		
	} // print(Node)
	
	private synchronized String normalize(String s) {
		
		__INNER_WORK_BUFFER.setLength( 0 );
		
		int len = (s != null) ? s.length() : 0;
		
		for ( int i = 0; i < len; i++ ) {
			char ch = s.charAt(i);
			switch ( ch ) {
				case '<': {
					__INNER_WORK_BUFFER.append("&lt;");
					break;
				}
				
				case '>': {
					__INNER_WORK_BUFFER.append("&gt;");
					break;
				}
				case '&': {
					__INNER_WORK_BUFFER.append("&amp;");
					break;
				}
				case '"': {
					__INNER_WORK_BUFFER.append("&quot;");
					break;
				}
				
				case '\r':
					
				case '\n': {
					if ( canonical ) {
						__INNER_WORK_BUFFER.append("&#");
						__INNER_WORK_BUFFER.append(Integer.toString(ch));
						__INNER_WORK_BUFFER.append(';');
						break;
					}
					// else, default append char
				}
				
				case '\\':{
					__INNER_WORK_BUFFER.append("\\\\");
					break;
				}
				
				default: {
					__INNER_WORK_BUFFER.append(ch);
				}
			}
		}
		
		return(__INNER_WORK_BUFFER.toString());
		
	}
	
	private String getWriterEncoding() {
		
		return PRINTWRITER_ENCODING;
	}
}

