/*
 * @(#)XmlErrorHandler.java            2004. 10. 29.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package com.humuson.tms.common.xml;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
/**
 * Class description :
 * 
 * @version		1.1
 * @author 		dragon
 *
 */
public class XmlErrorHandler implements org.xml.sax.ErrorHandler {
	
	/**
	 * Creates a new instance of XmlErrorHandler
	 */
	public XmlErrorHandler() {
	}
	
	public void warning(SAXParseException ex) 
			throws SAXException {
				
		System.err.println("[Warning] "
				+ getLocationString(ex)
				+ ": "
				+ ex.getMessage());
	}
	
	public void error(SAXParseException ex) 
			throws SAXException {
				
		System.err.println("[Error] "
				+ getLocationString(ex)
				+ ": "
				+ ex.getMessage());
	}
	
	public void fatalError(SAXParseException ex) 
			throws SAXException {
				
		System.err.println("[Fatal Error] "
				+ getLocationString(ex)
				+ ": "
				+ ex.getMessage());
		throw ex;
	}
	
	private String getLocationString(SAXParseException ex) {
		
		StringBuffer str = new StringBuffer();
		
		String systemId = ex.getSystemId();
		
		if (systemId != null) {
			int index = systemId.lastIndexOf('/');
			if (index != -1)
				systemId = systemId.substring(index + 1);
			str.append(systemId);
		}
		
		str.append(':');
		str.append(ex.getLineNumber());
		str.append(':');
		str.append(ex.getColumnNumber());
		
		return str.toString();
	}
}
