package com.humuson.tms.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.springframework.core.annotation.AnnotationUtils;

public class TmsAnnotationUtil extends AnnotationUtils{
	
	public static Annotation findOneAnnotation( Annotation[] annotation, Class<? extends Annotation> annotationType ) {
		for ( Annotation anno : annotation ) {
			if ( isAnnotationPresent(anno, annotationType) ) {
				return anno;
			}
		}
		return null;
	}
	
	public static Annotation findAnnotation( Annotation annotation, Class<? extends Annotation> annotationType ) {
		
		if ( annotation.annotationType().equals(annotationType) ) {
			return annotation;
		}
		
		for ( Annotation anno : annotation.annotationType().getDeclaredAnnotations() ) {
			if (anno.annotationType().equals(annotationType)) {
				return anno;
			}
		}
		
		return null;
	}
	
	public static boolean isAnnotationPresent( Annotation annotation, Class<? extends Annotation> annotationType ) {
		if ( findAnnotation(annotation, annotationType) != null ) {
			return true;
		}
		return false;
	}
	
	public static boolean isAnnotationPresent( Field field, Class<? extends Annotation> annotationType ) {
		for ( Annotation anno : field.getDeclaredAnnotations() ) {
			if ( isAnnotationPresent(anno, annotationType) ) {
				return true;
			}
		}
		return false;
	}
	
	public static Annotation[] findAnnotations( Field field, Class<? extends Annotation>[] annotationTypes ) {
		
		List<Annotation> list = new ArrayList<Annotation>();
		
		for ( Annotation anno : field.getDeclaredAnnotations() ) {
			
			for ( Class<? extends Annotation> type :  annotationTypes ) {
				Annotation a = findAnnotation(anno, type);

				if ( a != null ) {
					list.add(a);
				}
			}
			
		}
		return list.toArray(new Annotation[0]);
	}
	
	public static boolean isAnnotationPresent( Field field, Class<? extends Annotation>[] annotationTypes ) {
		
		for ( Annotation anno : field.getDeclaredAnnotations() ) {
			
			for ( Class<? extends Annotation> type :  annotationTypes ) {
				Annotation a = findAnnotation(anno, type);
				if ( a != null ) {
					return true;
				}
			}
			
		}
		return false;
	}
	
	/**
	 * annotations 중에  annotationType이 있는지 판별함.
	 * @param annotations		
	 * @param annotationType
	 * @return
	 */
	public static boolean isAnnotationPresent( Annotation[] annotations , Class<? extends Annotation> annotationType ) {
		for ( Annotation annotation : annotations ) {
			if ( isAnnotationPresent( annotation , annotationType ) ) {
				return true;
			}
		}
		return false;
	}
}
