package com.humuson.tms.common.util;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Locale;

import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.core.MethodParameter;
import org.springframework.core.NamedThreadLocal;

import com.humuson.tms.entityMap.propertyeditors.CustomSqlDateEditor;
import com.humuson.tms.entityMap.propertyeditors.CustomTimeEditor;

public class ThreadSafedSimpleTypeConverter implements TypeConverter {

	private final ThreadLocal<SimpleTypeConverter> simpleTypeConverters = new NamedThreadLocal<SimpleTypeConverter>("ThreadSafedSimpleTypeConverter_Converters") {
		@Override
		protected SimpleTypeConverter initialValue() {
			return createSimpleTypeConverter();
		}
	};

	public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
		return simpleTypeConverters.get().convertIfNecessary(value, requiredType);
	}

	public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
		return simpleTypeConverters.get().convertIfNecessary(value, requiredType, methodParam);
	}

//    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return simpleTypeConverters.get().convertIfNecessary(value, requiredType, field);
    }

    public SimpleTypeConverter getSimpleTypeConverter() {
		return simpleTypeConverters.get();
	}

	protected SimpleTypeConverter createSimpleTypeConverter() {
		SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
		simpleTypeConverter.registerCustomEditor(java.util.Date.class, new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()), true));
		simpleTypeConverter.registerCustomEditor(java.sql.Timestamp.class, new CustomTimestampEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()), true));
		simpleTypeConverter.registerCustomEditor(java.sql.Date.class, new CustomSqlDateEditor(new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()), true));
		simpleTypeConverter.registerCustomEditor(java.sql.Time.class, new CustomTimeEditor(new SimpleDateFormat("HH:mm:ss", Locale.getDefault()), true));
		simpleTypeConverter.registerCustomEditor(boolean.class, new CustomBooleanEditor(false));
		simpleTypeConverter.registerCustomEditor(Boolean.class, new CustomBooleanEditor(true));

		return simpleTypeConverter;
	}
}
