package com.humuson.tms.common.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

import org.apache.commons.codec.binary.Base64;

import com.humuson.tms.common.lang.Locale;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class StringUtils extends org.apache.commons.lang3.StringUtils{

	private static DecimalFormat	numberFormatter	= new DecimalFormat();

   
	public static boolean hasText(String str) {
		return org.springframework.util.StringUtils.hasText((CharSequence) str);
	}

	/**
	 * 문자열 null 처리.<br>
	 * 문자열이 null이면 널스트링('')으로 치환한다.<br>
	 * 그 외의 경우는 앞뒤 빈칸을 제거하여 리턴한다.
 	 * 
	 * @param strSource	원래의 문자열
	 * @return	결과 문자열
	 */
	public static String validString(String strSource)
	{
		if (strSource == null)
			return "";
		else
			return strSource.trim();
	}
	

	/**
	 * 객체가 null이면 널스트링('')으로 치환하고<br>
	 * String 객체이면 앞뒤 빈칸을 제거하여 리턴한다.<br>
	 * String 객체가 아니면 toString() 결과를 리턴한다.
	 * 
	 * @param obj	원래의 객체
	 * @return	결과 문자열
	 */
	public static String validString(Object obj)
	{
		if (obj == null) {
			log.info("validString obj is null");
			return "";
		} else if (obj instanceof String)
			return ((String)obj).trim();
		else
			return obj.toString();
	}
	
	public static String getSendListTable(String post_id) {
		if( post_id == null || post_id.length() < 6 ) {
			return "";
		}
		return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
	}

	
	public static final boolean isNull(String src) {
		if( src == null || src.trim().length() < 1 ){
			return true;
		}

		return false;
	}
	
	public static String queryCheck(String source) {

		if( source == null)
			return source;

		// ' " / \ ; : Space -- +
		source = replace(source, "'", "''");
		source = replace(source, "\"", "");
		source = replace(source, ";", "");
		//source = replace(source, ":", "");
		//source = replace(source, "/", "");
		source = replace(source, "\\", "");			
		source = replace(source, "--", "");
		source = replace(source, "+", "");	
		//source = replace(source, " ", "");
		
		return source;
	}
	
	/**
	 * src가 null 거나 ""이면 ""값으로 리턴한다.
	 * 
	 * @param src
	 *            문자열
	 * @return
	 */
	public static String nvl(String src) {
		return nvl(src, "");
	}

	/**
	 * <PRE>
	 * 
	 * src가 null거나 ""이면 tgt값으로 치환하여 return한다.
	 * @param src 문자열
	 * @param tgt 치환할 문자열
	 * @return 치환된 String
	 * 
	 * </PRE>
	 */
	public static String nvl(String src, String tgt) {
		String res = tgt;
		if (tgt == null)
			res = "";
		if (src == null)
			return res;
		else if (src.equals(""))
			return res;
		else
			return src;
	}

	/**
	 * Object가 null 일경우 기본문자열을 리턴한다.
	 * 
	 * @param obj
	 * @param def
	 *            기본 문자열
	 * @return
	 */
	public static String nvl(Object obj) {
		return nvl(obj, "");
	}

	/**
	 * Object가 null 일경우 기본문자열을 리턴한다.
	 * 
	 * @param obj
	 * @param def
	 *            기본 문자열
	 * @return
	 */
	public static String nvl(Object obj, String def) {
		if (obj == null)
			return def;
		return obj.toString();
	}

	/**
	 * 입력받은 String을 원하는 길이만큼 원하는 문자로 오른쪽을 채워주는 함수.
	 * 
	 * @param str
	 *            : 입력 문자열
	 * @param len
	 *            : 채우고 싶은 길이
	 * @param pad
	 *            : 채울문자
	 * @return 채워진 문자열
	 */
	public static String rpad(String str, int len, char pad) {
		String result = str;
		int templen = len - result.getBytes().length;
		for (int i = 0; i < templen; i++) {
			result = result + pad;
		}
		return result;
	}

	/**
	 * 입력받은 String을 원하는 길이만큼 원하는 문자로 왼쪽을 채워주는 함수.
	 * 
	 * @param str
	 *            : 입력 문자열
	 * @param len
	 *            : 채우고 싶은 길이
	 * @param pad
	 *            : 채울문자
	 * @return 채워진 문자열
	 */
	public static String lpad(String str, int len, char pad) {
		String result = str;
		int templen = len - result.getBytes().length;
		for (int i = 0; i < templen; i++)
			result = pad + result;
		return result;
	}

	/**
	 * <PRE>
	 * 
	 * 우편번호 타입으로 변환한다. (예) 630521 --> 630-521
	 * 
	 * </PRE>
	 * 
	 * @param postno
	 *            우편번호
	 * @return 변환된 우편번호 문자열
	 */
	public static String makePostType(String postno) {
		if (postno == null || postno.length() == 0)
			return "";
		if (postno.length() != 6)
			return postno;
		String postno1 = postno.substring(0, 3);
		String postno2 = postno.substring(3, 6);
		return (postno1 + "-" + postno2);
	}

	/**
	 * <PRE>
	 * 
	 * 전화 번호  타입으로 변환한다. (예) 0101234567 --> 010-123-4567
	 * 
	 * </PRE>
	 * 
	 * @param tel
	 *            전화번호
	 * @return 변환된 전화번호 문자열
	 */
	public static String makeTelType(String tel) {
		if (tel == null || tel.length() == 0)
			return "";
		String DELEMETER = "-";
		StringBuffer sb = new StringBuffer();
		String tnum = "";
		if (tel.startsWith("02")) {
			sb.append("02").append(DELEMETER);
			tnum = tel.substring(2);
		} else {
			sb.append(tel.substring(0, 3)).append(DELEMETER);
			tnum = tel.substring(3);
		}

		if (tnum.length() == 7) {
			sb.append(tnum.substring(0, 3)).append(DELEMETER).append(
					tnum.substring(3));
		} else if (tnum.length() == 8) {
			sb.append(tnum.substring(0, 4)).append(DELEMETER).append(
					tnum.substring(4));
		} else {
			return tel;
		}
		return sb.toString();
	}

	/**
	 * <PRE>
	 * 
	 * 주민등록 번호 타입으로 변환한다. (예) 6305211234567 --> 630521-1234567
	 * 
	 * </PRE>
	 * 
	 * @param postno
	 *            주민번호
	 * @return 변환된 주민번호 문자열
	 */
	public static String makeJuminType(String jumin) {
		if (jumin == null || jumin.length() == 0)
			return "";
		if (jumin.length() != 13)
			return jumin;
		String postno1 = jumin.substring(0, 6);
		String postno2 = jumin.substring(6);
		return (postno1 + "-" + postno2);
	}

	/**
	 * <PRE>
	 * 
	 * Post Code의 앞 세자리를 반환한다. (예) 123456 --> 123
	 * 
	 * </PRE>
	 * 
	 * @param postcode
	 *            우편번호 문자열
	 * @return 우편번호 앞 세자리 문자열
	 */
	public static String getPostCode1(String postcode) {
		if (postcode == null || postcode.length() == 0)
			return "";

		if (postcode.length() == 6)
			return postcode.substring(0, 3);
		else
			return postcode;
	}

	/**
	 * <PRE>
	 * 
	 * Post Code의 뒷 세자리를 반환한다. (예) 123456 --> 456
	 * 
	 * </PRE>
	 * 
	 * @param postcode
	 *            우편번호 문자열
	 * @return 우편번호 뒷 세자리 문자열
	 */
	public static String getPostCode2(String postcode) {
		if (postcode == null || postcode.length() == 0)
			return "";

		if (postcode.length() == 6)
			return postcode.substring(3);
		else
			return postcode;
	}

	/**
	 * <PRE>
	 * 
	 * 전화 번호의 국번을 반환한다. (예) 0101234567 --> 010,  01112345678 -> 011
	 * 
	 * </PRE>
	 * 
	 * @param tel
	 *            전화번호
	 * @return 국번 문자열
	 */
	public static String getTelNum1(String tel) {
		if (tel == null || tel.length() <= 3)
			return "";
		if (tel.startsWith("02")) {
			return "02";
		} else {
			return tel.substring(0, 3);
		}
	}

	/**
	 * <PRE>
	 * 
	 * 전화 번호의 앞번호를 반환한다. (예) 0101234567 --> 123,  01112345678 -> 1234
	 * 
	 * </PRE>
	 * 
	 * @param tel
	 *            전화번호
	 * @return 전화번호 앞번호 문자열
	 */
	public static String getTelNum2(String tel) {
		if (tel == null || tel.length() == 0)
			return "";
		if (tel.startsWith("02")) {
			if ((tel.length() - 2) == 7)
				return tel.substring(2, 5);
			else if ((tel.length() - 2) == 8)
				return tel.substring(2, 6);
			else
				return tel;
		} else {
			if ((tel.length() - 3) == 7)
				return tel.substring(3, 6);
			else if ((tel.length() - 3) == 8)
				return tel.substring(3, 7);
			else
				return tel;
		}
	}

	/**
	 * <PRE>
	 * 
	 * 전화 번호의 뒷번호를 반환한다. (예) 0101234567 --> 4567,  01112345678 -> 5678
	 * 
	 * </PRE>
	 * 
	 * @param tel
	 *            전화번호
	 * @return 전화번호 뒷번호 문자열
	 */
	public static String getTelNum3(String tel) {

		if (tel == null || tel.length() == 0)
			return "";
		if (tel.startsWith("02")) {
			if ((tel.length() - 2) == 7) {
				// logger.debug( tel.substring( 5 ) );
				return tel.substring(5);
			} else if ((tel.length() - 2) == 8) {
				// logger.debug( tel.substring( 6 ) );
				return tel.substring(6);
			} else
				return tel;
		} else {
			if ((tel.length() - 3) == 7) {
				// logger.debug( tel.substring( 6 ) );
				return tel.substring(6);
			} else if ((tel.length() - 3) == 8) {
				// logger.debug( tel.substring( 7 ) );
				return tel.substring(7);
			} else
				return tel;
		}
	}

	/**
	 * <PRE>
	 * 
	 * 성별 Type을 받아서 "남자, 여자"를 반환한다. (예) W -> 여자 , femail -> 여자 , m -> 남자
	 * 
	 * </PRE>
	 * 
	 * @param gender
	 * @return "남자/여자"
	 */
	public static String getGender(String gender) {
		if (gender == null || gender.length() == 0)
			return "";

		String gen = gender.toUpperCase();
		if (gen.equals("F") || gen.equals("FEMAIL") || gen.equals("W")
				|| gender.equals("WOMAN")) {
			return "여자";
		} else if (gen.equals("M") || gen.equals("MAIL")
				|| gender.equals("MAN")) {
			return "남자";
		} else {
			return gender;
		}
	}

	/**
	 * <pre>
	 *  space 를 _로 변환해서 리턴한다(get방식에서의 한글 스페이스 문제)
	 *  (예 : 홍 길 동 --> 홍_길_동)
	 * 
	 * </pre>
	 * 
	 * @param args
	 *            : 스페이스를 포함한 한글 문자열
	 * @return '_'를 포함한 한글 문자열
	 */
	public String encodeSpace(String str) {

		StringTokenizer st = new StringTokenizer(str);
		String spString = "";
		while (st.hasMoreTokens()) {
			spString = spString + st.nextToken() + "_";
		}
		return spString;
	}

	/**
	 * <pre>
	 * 
	 *  _ 를 space로 변환해서 리턴한다(get방식에서의 한글 스페이스 문제)
	 *  (예 : 홍_길_동 --> 홍 길 동)
	 * 
	 * </pre>
	 * 
	 * @param args
	 *            : '_'를 포함한 한글 문자열
	 * @return '_'를 제외한 한글 문자열
	 */
	public String decodeSpace(String str) {
		StringTokenizer st = new StringTokenizer(str, "_");
		String returnStr = "";
		while (st.hasMoreTokens()) {
			returnStr = returnStr + st.nextToken() + " ";
		}
		return returnStr;
	}

	/**
	 * <PRE>
	 * 
	 * 문자열중 특정문자를 제거한다 (예) 2001/01/01 ==> 20010101
	 * 
	 * </PRE>
	 * 
	 * @param str
	 *            대상문자열
	 * @param tok
	 *            제거할 문자열
	 * @return 완성된 문자열
	 */
	public static String remove(String str, String tok) {
		return replaceAll(str, tok, "");
	}

	/**
	 * Replace string start from given offset to given length.
	 * 
	 * @return String Replaced string.
	 * @param str
	 *            Original string.
	 * @param off
	 *            Given offset.
	 * @param len
	 *            Given length.
	 * @param replace
	 *            Given replcae string.
	 */
	public static String replace(String str, int off, int len, String replace) {
		StringBuffer buff = new StringBuffer(str);
		buff.replace(off, off + len, replace);
		return buff.toString();
	}

	/**
	 * Relace string start from given offset and replace one str2 with given
	 * replace string.
	 * 
	 * @return Replaced string.
	 * @param str1
	 *            Original string.
	 * @param off
	 *            Given offset.
	 * @param str2
	 *            Given string that will be replaced by other string.
	 * @param replace
	 *            Given replcae string.
	 */
	public static String replace(String str1, int off, String str2,
			String replace) {
		off = str1.indexOf(str2, off);
		if (off == -1)
			return str1;

		StringBuffer buff = new StringBuffer(str1);
		buff.replace(off, off + str2.length(), replace);
		return buff.toString();
	}

	/**
	 * Relace string start from given offset and replace all of str2 with given
	 * replace string.
	 * 
	 * @return Replaced string.
	 * @param str1
	 *            Original string.
	 * @param off
	 *            Given offset
	 * @param str2
	 *            Given source string.
	 * @param replace
	 *            Given target string.
	 */
	public static String replaceAll(String str1, int off, String str2,
			String replace) {
		if (str1 == null || str2 == null || replace == null)
			return str1;

		off = str1.indexOf(str2, off);
		StringBuffer buff = new StringBuffer(str1);
		while (off != -1) {
			buff.replace(off, off + str2.length(), replace);
			str1 = buff.toString();
			if (off + str2.length() < str1.length())
				off = str1.indexOf(str2, off + replace.length());
			else
				off = -1;
		}
		return str1;
	}

	/**
	 * Replace all source string to given target string.
	 * 
	 * @return Replcaed string.
	 * @param str1
	 *            Original string.
	 * @param str2
	 *            Given source string.
	 * @param replace
	 *            Given target string.
	 */
	public static String replaceAll(String str1, String str2, String replace) {
		return replaceAll(str1, 0, str2, replace);
	}

	/**
	 * <pre>
	 * 
	 *  str1 문자열을 str2 문자열로 파싱하여 문자배열로 리턴한다.
	 *  String str1 : 파싱할 문자
	 * <br>
	 * 
	 *  String str2 : 토큰
	 * 
	 * </pre>
	 * 
	 * @param str1
	 *            : Original string.
	 * @param str2
	 *            : 파싱할 문자
	 * @return Vector
	 */
	/*
	 * public static Vector split( String str1, String str2 ) { String str = "";
	 * String newStr = str1; Vector v = new Vector( ); while( newStr.length( ) >
	 * 0 ) { if (newStr.indexOf( str2 ) >= 0) { //구분자가 있다면 int ord =
	 * newStr.indexOf( str2 ); //구분자의 위치 str = newStr.substring( 0, ord ); //구분자
	 * 앞까지 잘라냄 v.addElement( new String( str ) ); newStr = newStr.substring( ord
	 * + 1 ); } else { v.addElement( new String( newStr ) ); break; } } return
	 * v; }
	 */

	/**
	 * 입력받은 문자열 중 size(byte)를 넘지 않도록 계산해서 해당 문자열을 돌려줌.
	 * 
	 * @param p_str
	 *            : 문자열
	 * @param p_len
	 *            : length
	 * @return
	 */
	public static String getShortString(String p_str, int p_len) {
		boolean chkFlag = false;
		String strName = p_str.trim();
		byte[] arName = strName.getBytes();
		if (arName.length > p_len) {
			for (int idx = 0; idx < p_len; idx++) {
				if (arName[idx] < 0) { // 0x80 이상 ( 1byte짜리. 키값들)
					chkFlag = !chkFlag; // true로
				} else {
					chkFlag = false; // false로
				}
			}
			if (chkFlag) {
				strName = new String(arName, 0, p_len + 1); // 홀수이면
			} else {
				strName = new String(arName, 0, p_len); // 짝수일때
			}
		} else {
			strName = new String(arName, 0, arName.length);
		}
		return strName;
	}

	/**
	 * 주어진 str을 max 만큼 자르고 뒤에 '...'을 붙인다.
	 * 
	 * <pre>
	 * 
	 * // for limited to 18 characters.
	 * ex) 'What are you doing now?' -> 'What are you doing...'
	 * 
	 * </pre>
	 * 
	 * @param str
	 *            Given original string.
	 * @param maxNum
	 *            Limited maximum length.
	 * @return Result string.
	 */
	public static String getShortStatement(String str, int maxNum) {
		return str.length() > maxNum ? getShortString(str, maxNum) + "..."
				: str;
	}

	/**
	 * 문자열에서 숫자만을 가져온다.
	 * 
	 * @return java.lang.String
	 * @param str
	 *            java.lang.String
	 */
	public static String getRawDigit(String str) {
		char[] c = str.toCharArray();
		StringBuffer buff = new StringBuffer();
		try {
			for (int i = 0; i < c.length; i++)
				if (Character.isDigit(c[i]))
					buff.append(c[i]);
		} catch (Exception ex) {
		}
		return buff.toString();
	}

	/**
	 * Altibase에서는 Numeric, int 등 숫자 필드에서 Empty String을 입력하려고 하면 Error 발생 Null이
	 * 입력가능한 필드는 null로 입력 할 수 있도록 변환
	 * 
	 * @param inStr
	 * @return
	 */
	public static String changeEmptyStringToNULL(String inStr) {
		if (inStr == null)
			return null;

		if (inStr.equals(""))
			return null;
		else
			return inStr;
	}

	/**
	 * 특수문자를 특수이름으로 변경
	 * 
	 * @param text
	 * @return
	 */
	public static String changeEntityReference(String text) {
		String result = text;

		result = StringUtils.replaceAll(result, "&", "&amp;");
		result = StringUtils.replaceAll(result, "'", "&apos;");
		result = StringUtils.replaceAll(result, "\"", "&quot;");
		result = StringUtils.replaceAll(result, "<", "&lt;");
		result = StringUtils.replaceAll(result, ">", "&gt;");

		return result;

	}

	/**
	 * 특수이름을 특수문자로 변경
	 * 
	 * @param text
	 * @return
	 */
	public static String changeNormalText(String text) {
		String result = text;

		result = StringUtils.replaceAll(result, "&gt;", ">");
		result = StringUtils.replaceAll(result, "&lt;", "<");
		result = StringUtils.replaceAll(result, "&quot;", "\"");
		result = StringUtils.replaceAll(result, "&apos;", "'");
		result = StringUtils.replaceAll(result, "&amp;", "&");

		return result;

	}

	/**
	 * return random String
	 * 
	 * @param minValue
	 * @param maxValue
	 * @param fixLength
	 * @return
	 */
	public static String getRandomString(int minValue, int maxValue,
			int fixLength) {
		double value = NumberUtils.getRandom(minValue, maxValue);
		String str = Double.toString(value);

		int index = str.indexOf(".");
		str = str.substring(0, index);

		if (fixLength == -1)
			return str;
		index = str.length();

		while (index < fixLength) {
			str = "0" + str;

			index++;
		}
		return str;
	}

    // 새로 추가 split by character
    public static String[] split(String source, char s) {
        Vector<String> v = new Vector<String>();
        char[] cArray;
        String[] result;
        String tmp;
        int cnt = 0;
        int last = 0;
        boolean quotationOpen = false;
        boolean quotationClose = false;

        if (source == null || source.equals(""))
            return null;

        cArray = source.toCharArray();

        for (int i = 0; i < cArray.length; i++) {
            cnt++;
            if (cArray[i] == '"') {
                if (quotationOpen == false) {
                    last++;
                    cnt--;
                    quotationOpen = true;
                    quotationClose = false;
                } else {
                    quotationOpen = false;
                    quotationClose = true;
                }
            }
            if ((cArray[i] == s && quotationOpen == false) || quotationClose == true) {
                tmp = new String(cArray, last, cnt - 1);
                v.addElement(tmp);
                cnt = 0;
                last = i + 1;
                quotationClose = false;
            }
        }
        if (last < cArray.length)
            v.addElement(source.substring(last));

        if (source.charAt(source.length() - 1) == s)
            v.addElement("");

        result = new String[v.size()];
        for (int i = 0; i < result.length; i++)
            result[i] = (String) v.elementAt(i);

        return result;
    }

	/**
	 * 인자로 받은 String 값이 enumString 값에 해당하는지 체크한다.
	 * 
	 * @param String
	 *            []
	 * @param String
	 * @return boolean
	 */
	public static boolean checkEnumString(String[] list, String val) {
		if (val == null)
			return false;

		for (String s : list) {
			if (s == null)
				continue;
			if (s.equals(val))
				return true;
		}

		return false;
	}

	/**
	 * base64 3번 암호화
	 * 
	 * @param src
	 * @return
	 */
	public static String encode(String src){
		if(nvl(src).equals(""))
			return "";
		else
			return new String(Base64.encodeBase64(Base64.encodeBase64(Base64.encodeBase64(src.getBytes()))));		
	}	
	
	
	/**
	 * base64 3번 복호화
	 * 
	 * @param src
	 * @return
	 */
	public static String decode(String src){
		if(nvl(src).equals(""))
			return "";
		else		
			return new String(Base64.decodeBase64(Base64.decodeBase64(Base64.decodeBase64(src))));		
	}
	
	public static String getRate(String s, String s1) {
		int i = 0;
		int j = 0;
		if( s == null || s1 == null )
			return "0";
		try {
			i = Integer.parseInt(s);
			j = Integer.parseInt(s1);
		}
		catch(NumberFormatException nfe) {
			return "0";
		}
		return getRate(i, j);
	}
	
	public static String replaceAllData(String strValue, String strOld, String strNew) 
	{
		if (strValue == null || strValue.length() == 0)
			return strValue;

		StringBuffer stringBuffer = new StringBuffer(strValue);
		int iOldSize = strOld.length();
		int iNewSize = strNew.length();
		int iBegin = 0;
		int iIndex = stringBuffer.indexOf(strOld, iBegin);
		while (iIndex >= 0) 
		{
			stringBuffer.delete(iIndex, iIndex + iOldSize);
			stringBuffer.insert(iIndex, strNew);
			iBegin = iIndex + iNewSize;
			if (iBegin < stringBuffer.length())
				iIndex = stringBuffer.indexOf(strOld, iBegin);
			else
				iIndex = -1;
		}
		
		return stringBuffer.toString();
	}
	
	public static String replaceAllSection(String strValue, String sOld, String eOld, String strNew){
		if (strValue == null || strValue.length() == 0)
			return strValue;

		String temp = strValue;
		int so = 0;
		int eo = 0;
		String subStr = "";
		
		while (so>-1 || eo>-1){
			so = temp.indexOf(sOld);
			eo = temp.indexOf(eOld,so);
			if (so>-1 && eo>-1){
				subStr = temp.substring(so,eo+1);
				temp = temp.replace(subStr, strNew);
			} 
		}
		
		return temp;
	}
	
	/**
     * html 태그를 치환한 결과를 리턴함.
     *
     * @param htmlString
     * @return
     */
    public static String replaceHTMLTag(String htmlString) {
        // Remove HTML tag from java String
        // String noHTMLString = htmlString.replaceAll("\\<.*?\\>", "");
        if (isEmpty(htmlString))
            return "";

        String noHTMLString = htmlString.replaceAll(";", "；");
        noHTMLString = noHTMLString.replaceAll("%3B", "；");
        noHTMLString = noHTMLString.replaceAll("%27", "&#39;");

        noHTMLString = noHTMLString.replaceAll("<", "&lt;");
        noHTMLString = noHTMLString.replaceAll(">", "&gt;");

        noHTMLString = noHTMLString.replaceAll("\\(", "&#40;");
        noHTMLString = noHTMLString.replaceAll("\\)", "&#41;");

        noHTMLString = noHTMLString.replaceAll("\r\n", "<br/>");

        // Remove Carriage return from java String
        noHTMLString = noHTMLString.replaceAll("\r", "<br/>");

        // Remove New line from java string and replace html break
        noHTMLString = noHTMLString.replaceAll("\n", "<br/>");
        noHTMLString = noHTMLString.replaceAll("\'", "&#39;");
        noHTMLString = noHTMLString.replaceAll("\"", "&quot;");
        return noHTMLString;
    }

    /**
     * html 태그로 피환한 결과를 리턴함.
     *
     * @param replatedString
     * @return
     */
    public static String replacedStringToHtmlTag(String replatedString) {
        // Remove HTML tag from java String
        // String noHTMLString = htmlString.replaceAll("\\<.*?\\>", "");
        if (isEmpty(replatedString))
            return "";

        String htmlString = replatedString.replaceAll("；", ";");

        htmlString = htmlString.replaceAll("&lt;", "<");
        htmlString = htmlString.replaceAll("&gt;", ">");

        htmlString = htmlString.replaceAll("&#40;", "(");
        htmlString = htmlString.replaceAll("&#41;", ")");

        htmlString = htmlString.replaceAll("&#39;", "\'");

        // Remove Carriage return from java String
        htmlString = htmlString.replaceAll("<br/>", "\r\n");
    /*
     * htmlString = htmlString.replaceAll("<br/>", "\r"); htmlString = htmlString.replaceAll("<br/>", "\n");
     */

        htmlString = htmlString.replaceAll("&#39;", "\'");
        htmlString = htmlString.replaceAll("&quot;", "\"");
        return htmlString;
    }
    
    public static final String getDomain(String str) {
		if( str == null )
			return "";
		int index = str.indexOf('@');
		if( index < 0 )
			return "";
		return str.substring(index + 1);
	}

	/**
	 * 전화번호에서 통신사 번호를 뽑는다. author 김정섭 ^^
	 * 
	 * @param str
	 *            원본 전화번호
	 * @return 전화번호의 통신사번호
	 */
	public static final String getTeleCom(String str) {
		if( str == null || str.length()<10)
			return "";
		return str.substring(0, 3);
	}

	/**
	 * 이메일 주소의 정합성을 검사한다.
	 * 
	 * @param inemail
	 *            검사할 이메일
	 * @return true : 정상 / false : 오류이메일
	 */
	public static final boolean isEmailError(String inemail) {
		if (inemail == null) return false;
		String email = inemail.trim();

		if( email.indexOf('@') < 0 )
			return true;

		if( !isValidHost(getDomain(email)) )
			return true;

		return false;
	}

	/**
	 * SMS의 정합성을 검사한다.
	 * 
	 * @param inSms : 검사할 이메일
	 * @return true : 비정상 / false : 정상
	 */
	public static final boolean isSmsError(String inSms) {
		if (inSms == null)
			return false;
		String SMS = inSms.trim();
		
		return !Pattern.matches("^(01[016789]{1}|02|0[3-9]{1}[0-9]{1})-?[0-9]{3,4}-?[0-9]{4}$", SMS);
	}

	/**
	 * 도메인 스트링의 정합성을 검증한다.
	 * 
	 * @param host
	 *            도메인 스트링
	 * @return true : 유효도메인 / false : 무효도메인
	 */
	public static final boolean isValidHost(String host) {
		if( host.indexOf("@") > 0 || host.indexOf(".") < 0 || host.indexOf(" ") > 0 || host.startsWith(".") || host.endsWith(".")
				|| host.indexOf("..") > 0 || host.startsWith("-") ) {
			return false;
		}

		// 유효문자 점검
		for (int i = 0; i < host.length(); i++) {
			int ch = host.charAt(i);
			if( (ch >= 48 && ch <= 57) || (ch >= 65 && ch <= 90) || (ch >= 97 && ch <= 122) || (ch == 45) || (ch == 46) || (ch == 95) ) {
			}
			else {
				return false;
			}
		}

		return true;
	}
	
	/**
	 * input 문자열에서 mappingSymbol 데이터를 mapData 으로 변환시켜 반환한다.
	 * @param input 입력 문자열
	 * @param mappingSymbol 변환시킬 대상 문자열
	 * @param mapData 변환결과 문자열
	 * @return
	 */
	static public String convertMappingString(String input, String mappingSymbol, String mapData) {
		return input.replace(mappingSymbol, mapData);
	}
	
	/**
	 * input 문자열의 idx 부터 length 만클의 길이를 bytes 단위로 잘라서 반환한다.
	 * @param input 입력 문자열
	 * @param idx 입력 문자열의 시작 index
	 * @param length 반환할 문자열의 길이
	 * @return 변환결과 문자열
	 */
	public static String substring(String input, int idx, int length) {
        if( input.getBytes().length <= idx ) {
            return "";
        }

        if( input.getBytes().length <= length ) {
            return input;
        }

        int totallen=0;
        int i=idx;
        for( i=idx; i<input.length(); i++ ) {
            totallen += input.substring(i, i+1).getBytes().length;

            if( length < totallen ) {
                break;
            }
        }

        return input.substring(idx, i);
    }

	/**
	 * input 문자열에서 length 만클의 길이를 bytes 단위로 잘라서 반환한다.
	 * @param input 입력 문자열
	 * @param length 반환할 문자열의 길이
	 * @return 변환결과 문자열
	 */
    public static String substring(String input, int length) {
        return substring(input, 0, length);
    }
    
    public static String moneyForm(String number) {
		if( number == null || number.trim().length() == 0 )
			return " ";
		return toFormatedNumber(number, "#,##0");
	}
    
    /**
	 * @param number
	 * @param pattern
	 * @return converted format string
	 */
	public static final String toFormatedNumber(String number, String pattern) {
		if( number == null )
			return " ";

		double src = 0;
		try {
			src = Double.parseDouble(number);
		}
		catch(Exception e) {
			return number;
		}

		String returnValue = null;

		synchronized (numberFormatter) {
			try {
				numberFormatter.applyPattern(pattern);
				returnValue = numberFormatter.format(src);
			}
			catch(Exception e) {
				return number;
			}
		}

		return (returnValue == null) ? " " : returnValue;
	}
	
	/**
	 * @param str
	 * @return
	 */
	public static String trimNull(String str) {

		return (str == null) ? null : str.trim();
	}
	
	public static String getRate(float i, float j) {
		float f = 0.0F;
		if( j != 0 )
			f = ( i / j) * 100;
		else
			return "0.00000";

		String ret = String.valueOf(f);
		int idx;
		if( (idx = ret.indexOf(".")) != -1 ) {
			if(ret.length()-idx >= 3){
				
				ret = ret.substring(0, idx + 3);
			}
		}
		else {
			ret = ret + ".00";
		}
		return ret;
	}
	
	/**
	 * 입력받은 문자열이 숫자인지 체크
	 * @param str
	 * @return
	 */
	public static boolean checkNum( String str ) {
		char c;
		if ( isNull(str) ) { return false;
		} else {
			for ( int i=0; i<str.length(); i++) {
				c = str.charAt(i);
				if ( c<48 || 57<c ) return false;
			}
		}
		return true;
	}
	
	/**
	 * length 만큼의 길이를 갖는 비밀번호를 임의로 반환한다.
	 * @param length
	 * @return
	 */
	public static String getRandomPassword( int length ) {
		int index = 0;
		char[] charSet = new char[] {
				'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
				, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M'
				, 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
				, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'
				, 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
		};
		StringBuffer sb = new StringBuffer();
		for ( int i=0; i<length; i++ ) {
			index = (int) (charSet.length * Math.random());
			sb.append(charSet[index]);
		}

		if (log.isDebugEnabled()) log.debug("getRandowmPassword : {}", sb.toString());
		return sb.toString();
	}
	
	public static String replace(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
	
	/**
	 * Calendar 객체를 기준으로 양식에 맞는 날짜 문자열을 가져온다.
	 * @param format (ex yyyy.MM.dd // yyyy.MM.dd HH:mm:ssz)
	 * @return
	 */
	public static String getCurrentDate( String format ) {
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(cal.getTime());
	}
	
	/**
	 * 오늘로부터 입력한 일자(changeDay)만큼 변화된 날짜를 반환한다.
	 * @param format 반환할 날짜유형(ex yyyy.MM.dd)
	 * @param changeDay 변화시킬 일자의 수치
	 * @return 변환된 날짜
	 */
	public static String changeDayFromToday( String format, int changeDay ) {
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		cal.add(Calendar.DATE, changeDay);
		return sdf.format(cal.getTime());
	}
	

	public static String parseSQL(String source, String mapping, String value, boolean sql) {

		if( mapping == null || source == null )
			return source;

		if( sql )
			value = replace(value, "'", "''");

		return replace(source, "${" + mapping + "}", Locale.toDb(value));
	}

	
	public static String parseSQL(String source, String mapping, String value) {
		return parseSQL(source, mapping, value, true);
	}

	
	public static String parseSQL(String source, Map<?,?> map, boolean sql) {

		if( map == null )
			return source;

		Set<?> kSet = map.keySet();
		String key;
		String value;

		for (Iterator<?> it = kSet.iterator(); it.hasNext();) {
			key = (String) it.next();
			value = (String) map.get(key);
			source = parseSQL(source, key, value, sql);
		}
		return source;
	}
	
	/**
	 * 입력받은 스트링에서 BOM을 제거한다
	 * @param str
	 * @return
	 */
	public static String removeBOM(String str) {
		if(str == null || "".equals(str)){
			return str;
		}

	    if (str.startsWith("\uFEFF")) {
	    	str = str.substring(1);
	    }else if (str.startsWith("\uFFFE")) {
	    	str = str.substring(1);
	    }else if(str.startsWith("\uEFBBBF")){
	    	str = str.substring(1);
	    }else if(str.startsWith("\u0000FEFF")) {
	    	str = str.substring(1);
	    }else if(str.startsWith("\uFFFE0000")) {
	    	str = str.substring(1);
	    }else if(str.startsWith("\u0000FEFF")) {
	    	str = str.substring(1);
	    }
	    return str;
	}
	
	
	public static void main(String[] args) {
		System.out.println(StringUtils.getDomain("0a0Y9z69gqYBFCmbVja035GROOoxP5abotYTgLC5Q6xoK+oZcDU2X0fh8DfJTRsU"));
	}
}
