package com.humuson.tms.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author erzisk
 * @since 2013.08.06
 */
public class SiteUtil {
	
	private static final Logger logger = LoggerFactory.getLogger(SiteUtil.class);
	
	/**
	 * get Link From html
	 * @param htmlStr
	 * @return
	 */
	public static Map<Integer, String> getLinkFromHtml(String htmlStr) {
		Map<Integer, String> map = new HashMap<Integer, String>();
		Pattern p = Pattern.compile("<a\\s*href\\s*=\\s*([\"']*)(http[^\"'>\\s]+)\\1(.*?)>(.*?)</a>");
		Matcher m = p.matcher(htmlStr);
		for (int i = 1; m.find(); i++) {
			map.put(i, m.group(2));
		}
		if (logger.isDebugEnabled())
			logger.debug("getLinkFromHtml {}", map.toString());
		return map;
	}
	
}
