package com.humuson.tms.common.util;

import com.humuson.tms.common.model.CcsMessageId;
import com.humuson.tms.common.model.mq.PushSendType;
import com.humuson.tms.constrants.CommonType;

import lombok.extern.slf4j.Slf4j;

/**
 * CCS message id 를 필요한 포멧에 맞추어 리턴함.
 * 
 * @author sgeom
 *
 */
@Slf4j
public class PushCcsMessageIdUtil {
	
	
	public static String makeCcsMessageId(long pushId, long deviceId, String reqUid, String custId,int appGrpId,String serverId, PushSendType type){
		StringBuffer sb = new StringBuffer();
		sb.append(String.valueOf(pushId))
			.append("&&").append(String.valueOf(deviceId))
			.append("&&").append(reqUid)
			.append("&&").append(custId)
			.append(":").append(appGrpId)
			.append(":").append(serverId)
			.append(":").append(type.getCode());
		return sb.toString();
	}
	
	public static String makeCcsMessageId(String id, int appGrpId,String serverId, PushSendType type){
		StringBuffer sb = new StringBuffer();
		sb.append(id)
			.append(":").append(appGrpId)
			.append(":").append(serverId)
			.append(":").append(type.getCode());
		return sb.toString();
	}
	
	public static CcsMessageId parseCcsMessageId(String messageId){
		CcsMessageId msg = new CcsMessageId();
		String splitMsgId[] = messageId.split(":");
		String splitId[] = splitMsgId[0].split("&&");
		CommonType commonSendType;
		msg.setId(splitMsgId[0]);
		try{
			msg.setPushId(Long.parseLong(splitId[0]));
		}catch(Exception e){
			
		}
		msg.setDeviceId(Long.parseLong(splitId[1]));
		msg.setReqUid(splitId[2]);
		msg.setCustId(splitId[3]);
		msg.setAppGrpId(Integer.parseInt(splitMsgId[1]));
		msg.setServerId(splitMsgId[2]);
		msg.setPushSendType(PushSendType.valueOfCode(splitMsgId[3]));
		try{
    	   if(msg.getReqUid().startsWith("AA")){
    		   commonSendType = CommonType.AUTO;
    	   }else if(msg.getReqUid().startsWith("CC")){
    		   commonSendType = CommonType.CAMP;
    	   }else{
    		   commonSendType = CommonType.TEST;
    	   }
       }catch(Exception e){
    	   commonSendType = CommonType.CAMP;
    	   log.error("CCS Receive Msg ReqUid Parse Fail => can not decide SendType(CAMP-AUTO) data : {} /  ", msg.toString());
    	   log.error("ReqUid Parse Fail Data Input Camp Response Que ");
        }
		msg.setCommonSendType(commonSendType);
		return msg;
	}
	
}
