package com.humuson.tms.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
	private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
	
	public static boolean isValidFile(String fileName) {
		
		boolean valid = true;
		
		File file = new File(fileName);
		
		if (!file.exists() || file.isDirectory()) {
			valid = false;
		}
		
		return valid;		
	}
	
	public static boolean existsLocal(String fName, String fDir) {

		File oFile = new File(fDir);
		String[] aFiles = oFile.list();

		if( aFiles == null )
			return false;

		boolean bFileExist = false;

		for (int i = 0; i < aFiles.length; i++) {
			if( aFiles[i].equals(fName) )
				bFileExist = true;
		}

		return bFileExist;
	}
	
	public static boolean moveFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
		
		File file = new File(fileDirPath + "/" + fileName);
		
		return file.renameTo(new File(destDirPath + "/" + toFileName));
	}
	
	public static boolean moveFile(String fileName, String fileDirPath, String destDirPath) {
		
		File file = new File(fileDirPath + "/" + fileName);
		
		return file.renameTo(new File(destDirPath + "/" + fileName));
	}
	
	public static void copyFile(String fileName, String fileDirPath, String destDirPath) {
		copyFile(fileName, fileName, fileDirPath, destDirPath);
	}
	
	public static void copyFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
		FileInputStream fis = null;
		FileOutputStream fos = null;
		FileChannel fcIn = null;
		FileChannel fcOut = null;
		
		try {
			
			File sourceFile = new File(fileDirPath + "/" + fileName);
			File destFile = new File(destDirPath + "/" + fileName);
			
			fis = new FileInputStream(sourceFile);
			fos = new FileOutputStream(destFile);
			
			fcIn = fis.getChannel();
			fcOut = fos.getChannel();
			
			long size = fcIn.size();
			fcIn.transferTo(0, size, fcOut);
			
			
		} catch(IOException e) {
			logger.error("copyFile IOException", e);
		} finally {
			
			if(fcIn != null) {
				try {
					fcIn.close();
				} catch (IOException e) {					
					logger.error("fcIn close IOException", e);
				}
			}
			
			if(fcOut != null) {
				try {
					fcOut.close();
				} catch (IOException e) {	
					logger.error("fcOut close IOException", e);
				}
			}
			
			if(fis != null) {
				try {
					fis.close();
				} catch (IOException e) {
					logger.error("fis close IOException", e);
				}
			}
			
			if(fos != null) {
				try {
					fos.close();
				} catch (IOException e) {					
					logger.error("fos close IOException", e);
				}
			}
			
		}
	}
	
	/**
	 * url을 참조하여 파일을 읽어서 return pluto.io.HttpFileElement 참조
	 *
	 * @param url
	 * @return
	 * @throws java.io.IOException
	 */
	public static String readUrl(String url) throws IOException {

		if( url == null )
			return null;

		URL myURL = new URL(url.trim());
		HttpURLConnection m_client;

		int __RESPONSE_CODE__ = 0;

		try {
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}
		catch(Exception ignore) {
			try {
				Thread.sleep(1000);
			}
			catch(Exception _ex) {
			}
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}

		switch (__RESPONSE_CODE__) {
			case HttpURLConnection.HTTP_FORBIDDEN: {
				throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
			}

			case HttpURLConnection.HTTP_INTERNAL_ERROR: {
				throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
			}

			case HttpURLConnection.HTTP_NOT_ACCEPTABLE: {
				throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
			}

			case HttpURLConnection.HTTP_NOT_FOUND: {
				throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
			}

			case HttpURLConnection.HTTP_UNAVAILABLE: {
				throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
			}

			case HttpURLConnection.HTTP_OK: {
				break;
			}

			default: {
				throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
			}
		}

		InputStream is = m_client.getInputStream();

		// read from inputstream
		byte[] b = new byte[2 << 6];

		int j;

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		while (true) {
			j = is.read(b);
			if( j <= 0 )
				break;

			baos.write(b, 0, j);
		}

		// release
		if( m_client != null ) {
			try {
				m_client.disconnect();
			}
			catch(Exception e) {
			}
		}

		return baos.toString("UTF-8");
	}

	/**
	 * url을 지정된 언어셋으로 파일을 읽어서 return pluto.io.HttpFileElement 참조
	 *
	 * @param url
	 * @return
	 * @throws java.io.IOException
	 */
	public static String readUrl(String url ,String charset) throws IOException {

		if( url == null )
			return null;
		url = url.trim();
		URL myURL = new URL(url);
		
		HttpURLConnection m_client;

		int __RESPONSE_CODE__ = 0;

		try {
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}
		catch(Exception ignore) {
			try {
				Thread.sleep(1000);
			}
			catch(Exception _ex) {
			}
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}

		switch (__RESPONSE_CODE__) {
			case HttpURLConnection.HTTP_FORBIDDEN: {
				throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
			}

			case HttpURLConnection.HTTP_INTERNAL_ERROR: {
				throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
			}

			case HttpURLConnection.HTTP_NOT_ACCEPTABLE: {
				throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
			}

			case HttpURLConnection.HTTP_NOT_FOUND: {
				throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
			}

			case HttpURLConnection.HTTP_UNAVAILABLE: {
				throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
			}

			case HttpURLConnection.HTTP_OK: {
				break;
			}

			default: {
				throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
			}
		}

		InputStream is = m_client.getInputStream();

		// read from inputstream
		byte[] b = new byte[2 << 6];

		int j;

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		while (true) {
			j = is.read(b);
			if( j <= 0 )
				break;

			baos.write(b, 0, j);
		}

		// release
		if( m_client != null ) {
			try {
				m_client.disconnect();
			}
			catch(Exception e) {
			}
		}
		return baos.toString(charset);
	}
	
	/**
	 * 파일경로가 없으면 만들어 준다.
	 * @param filePath
	 * @return
	 */
	public static void makeUrl(String fileUploadUrl) throws IOException {
		File file = new File(fileUploadUrl);
		if (!file.isDirectory()){
			file.mkdirs();
		}
	}
	
	/**
	 * Local File에 기록한다.
	 * 
	 * @param fName
	 * @param s
	 * @param add
	 * @throws IOException
	 */
	public static void writeLocal(String fName, String s, boolean add) throws IOException {

		File f = new File(fName);
		writeLocal(f, s, "UTF-8", add);
	}
	
	/**
	 * 해당 인코딩으로 Local File에 기록한다.
	 * 
	 * @param fName
	 * @param s
	 * @param add
	 * @throws IOException
	 */
	public static void writeLocal(String fName, String s, String enc, boolean add) throws IOException {

		File f = new File(fName);
		writeLocal(f, s, enc, add);
	}
	
	/**
	 * Local File에 기록한다.
	 * 
	 * @param f
	 * @param s
	 * @param add
	 * @throws IOException
	 */
	public static void writeLocal(File f, String s, String enc, boolean add) throws IOException {

		if( s == null )
			return;

		ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes(enc));
		byte[] b = new byte[2 << 6];

		FileOutputStream fos = new FileOutputStream(f, add);

		int j;

		while (true) {
			j = bais.read(b);
			if( j <= 0 )
				break;

			fos.write(b, 0, j);
			fos.flush();
		}
	}
	
	/**
	 * Local File을 읽어 String으로 반환한다.
	 * 
	 * @param f
	 * @return
	 * @throws IOException
	 */
	public static String readLocal(File f, String enc) throws IOException {

		FileInputStream fis = new FileInputStream(f);
		byte[] b = new byte[2 << 6];

		int j;

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		while (true) {
			j = fis.read(b);
			if( j <= 0 )
				break;

			baos.write(b, 0, j);
		}

		return baos.toString(enc);
	}
	
	/**
	 * Local File을 읽어 String으로 반환한다.
	 * 
	 * @param fName
	 * @return
	 * @throws IOException
	 */
	public static String readLocal(String fName) throws IOException {

		File f = new File(fName);
		if(f.exists()){
			return readLocal(f, "UTF-8");
		}else{
			return "";
		}
		
	}
	
	/**
	 * Local File을 읽어 String으로 반환한다.
	 * 
	 * @param fName
	 * @return
	 * @throws IOException
	 */
	public static String readLocal(String fName, String enc) throws IOException {

		File f = new File(fName);
		return readLocal(f, enc);
	}
	
	private static byte[]	__FILE_COPY_BUFFER	= null;

	public synchronized static boolean fileCopy(String src, String dest) {
		if( __FILE_COPY_BUFFER == null )
			__FILE_COPY_BUFFER = new byte[4096];

		FileInputStream in = null;
		FileOutputStream out = null;

		try {
			in = new FileInputStream(src);
			out = new FileOutputStream(dest);

			while (true) {
				int size = in.read(__FILE_COPY_BUFFER);

				if( size < 0 )
					break;

				out.write(__FILE_COPY_BUFFER, 0, size);
			}
		}
		catch(Exception e) {
			return false;
		}
		finally {
			if( in != null ) {
				try {
					in.close();
				}
				catch(Exception e) {
				}
			}
			if( out != null ) {
				try {
					out.close();
				}
				catch(Exception e) {
				}
			}
		}

		return true;
	}
	
	public static void upload(InputStream stream, String path) throws FileNotFoundException, IOException {

		int bytesRead = 0;
		OutputStream bos = null;
    	
        try
        {       	
            bos = new FileOutputStream(path);
			
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1)
            {
                bos.write(buffer, 0, bytesRead);
            }

            bos.close();
			stream.close();

        } catch (Exception e) {
        	e.printStackTrace();
	    }finally{
	    	if(stream != null){stream.close();}
	    	if(stream != null){bos.close();}
	    }
	}
	
	public static String upload(InputStream stream, String originFileName, String filePath) throws FileNotFoundException, IOException {

		String fileName = makeName(originFileName, false);
		upload(stream, filePath + fileName);
		
		return fileName;
	}
	
	public static String uploadNew(InputStream stream, String originFileName, String filePath) throws FileNotFoundException, IOException {

		String fileName = makeNameNew(originFileName);
		upload(stream, filePath + fileName);
		
		return fileName;
	}
	
	/*	파일이름생성 (LongTime_Rand4 + ext) */
    public static String makeName(String sExt, boolean reverse) {
        int nRand;
        while (true)
        {
            nRand = (int) (Math.random() * 10000);
            if (nRand > 1000)
                break;
        }
        if(reverse){
        	return sExt + "_" + new java.util.Date().getTime() + "_" + nRand;
        }else{
        	return new java.util.Date().getTime() + "_" + nRand + "_" + sExt;
        }
    }
    
	/*	파일이름생성 (LongTime_Rand4) */
    public static String makeNameNew(String sExt) {
        int nRand;
        while (true)
        {
            nRand = (int) (Math.random() * 10000);
            if (nRand > 1000)
                break;
        }
       return new java.util.Date().getTime() + "_" + nRand + sExt.substring(sExt.lastIndexOf("."));
       
       
       
       
    }

}
