package com.humuson.tms.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Iterator;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelDataConvertor {
	
	private static final String NEW_LINE_CHARACTER = "\r\n";
	private static final String CVS_SEPERATOR_CHAR = ",";
//	private static final String OUTPUT_DATE_FORMAT= "yyyy-MM-dd";
	
	public static void csvToEXCEL(String csvFileName, String excelFileName) throws Exception {
		
		checkValidFile(csvFileName);
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(csvFileName)));
		HSSFWorkbook workBook = new HSSFWorkbook();
		FileOutputStream writer = new FileOutputStream(new File(excelFileName));
		HSSFSheet sheet = workBook.createSheet();
		
		String line = "";
		int rowNo = 0;
		
		while ((line = reader.readLine()) != null) {
			String[] columns = line.split(CVS_SEPERATOR_CHAR);
			HSSFRow row = sheet.createRow(rowNo);
			for (int i = 0; i < columns.length; i++) {
				HSSFCell cell = row.createCell(i);
				cell.setCellValue(columns[i]);
			}
			rowNo++;
		}
		workBook.write(writer);
		writer.close();
		reader.close();		
	}
	
	public static void XSLXToCSV(String excelFileName, String csvFileName)	throws Exception {
		XSLXToCSV(excelFileName, csvFileName, "EUC-KR");
	}
	
	public static void XSLXToCSV(String excelFileName, String csvFileName, String charSet) throws Exception {
		XSLXToCSV(excelFileName, csvFileName, charSet, CVS_SEPERATOR_CHAR);
	}
	
//	public static void XSLXToCSV(String excelFileName, String csvFileName, String charSet, String delim) throws Exception {
//		
//		if(!checkValidFile(excelFileName)) {
//			throw new Exception("The excel file name is not valid!!!");
//		}		
//		
//		OPCPackage p = OPCPackage.open(excelFileName, PackageAccess.READ);
//		
//		XLSX2CSV xlsx2csv = new XLSX2CSV(p, new PrintStream(csvFileName, charSet), 2);
//		xlsx2csv.process();
//		p.revert();
//	}
	
	/**
	 * 2016.12.16 ljs
	 * 기존 소스 xlsx -> csv(txt) 변환시 마지막 라인 Blank Line이 삽입되어 수정
	 */
	public static void XSLXToCSV(String excelFileName, String csvFileName, String charSet, String delim) throws Exception {
		
		if(!checkValidFile(excelFileName)) {
			throw new Exception("The excel file name is not valid!!!");
		}
		
		XSSFWorkbook workBook = new XSSFWorkbook(new FileInputStream(excelFileName)); 
								
		XSSFSheet sheet = workBook.getSheetAt(0);
		Iterator<Row> rowIter = sheet.rowIterator();
		
		StringBuilder scvData = new StringBuilder();
		Writer outFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(csvFileName), charSet));
		
		int cnt = 0;
		
		while (rowIter.hasNext()) {
			
			if (cnt > 0) outFile.write(NEW_LINE_CHARACTER);
			
			XSSFRow row = (XSSFRow) rowIter.next();
			
			scvData.setLength(0);
			for (int i = 0; i < row.getLastCellNum(); i++) {
				if (row.getCell(i).getCellType() == XSSFCell.CELL_TYPE_NUMERIC) {
					scvData.append(Long.toString((long)row.getCell(i).getNumericCellValue()));
				}else {
					scvData.append(row.getCell(i).getStringCellValue());
				}
				scvData.append(delim);
			}
			outFile.write(scvData.substring(0, scvData.length()-1).toString());
			
			cnt++;
		}
		outFile.close();
	}
	
	
	public static void XSLToCSV(String excelFileName, String csvFileName)	throws Exception {
		XSLToCSV(excelFileName, csvFileName, "EUC-KR");
	}
	
	public static void XSLToCSV(String excelFileName, String csvFileName, String charSet)	throws Exception {
		XSLToCSV(excelFileName, csvFileName, charSet, CVS_SEPERATOR_CHAR);
	}
	public static void XSLToCSV(String excelFileName, String csvFileName, String charSet, String delim)	throws Exception {
		
		if(!checkValidFile(excelFileName)) {
			throw new Exception("The excel file name is not valid!!!");
		}
		
		HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(new FileInputStream(excelFileName)));
		HSSFSheet sheet = workBook.getSheetAt(0);
		Iterator<Row> rowIter = sheet.rowIterator();
		
		StringBuilder scvData = new StringBuilder();
		Writer outFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(csvFileName), charSet));
		
		int cnt = 0;
		
		while (rowIter.hasNext()) {
			
			if (cnt > 0) outFile.write(NEW_LINE_CHARACTER);
			
			HSSFRow row = (HSSFRow) rowIter.next();
			scvData.setLength(0);
			for (int i = 0; i < row.getLastCellNum(); i++) {
				if (row.getCell(i).getCellType() == HSSFCell.CELL_TYPE_NUMERIC) {
					scvData.append(Long.toString((long)row.getCell(i).getNumericCellValue()));
				}else {
					scvData.append(row.getCell(i).getStringCellValue());
				}
				scvData.append(delim);
			}
			outFile.write(scvData.substring(0, scvData.length()-1).toString());
			
			cnt++;
		}
		
		outFile.close();
	}
	
//	private static String getCellData(HSSFCell myCell) throws Exception {
//		
//		String cellData = "";
//		
//		if (myCell == null) {
//			
//			cellData += CVS_SEPERATOR_CHAR;
//		
//		} else {
//			
//			switch (myCell.getCellType()) {
//			case HSSFCell.CELL_TYPE_STRING:
//			
//			case HSSFCell.CELL_TYPE_BOOLEAN:
//				cellData += myCell.getRichStringCellValue()	+ CVS_SEPERATOR_CHAR;
//				break;
//			
//			case HSSFCell.CELL_TYPE_NUMERIC:
//				cellData += getNumericValue(myCell);
//				break;
//			
//			case HSSFCell.CELL_TYPE_FORMULA:
//				cellData += getFormulaValue(myCell);
//			
//			default:
//				cellData += CVS_SEPERATOR_CHAR;
//			
//			}
//		}
//		
//		return cellData;
//	}

//	private static String getNumericValue(HSSFCell myCell) throws Exception {
//		
//        String cellData="";
//        
//		if (HSSFDateUtil.isCellDateFormatted(myCell)) {
//			
//			cellData += new SimpleDateFormat(OUTPUT_DATE_FORMAT).format(myCell.getDateCellValue()) + CVS_SEPERATOR_CHAR;
//			
//		} else {
//			
//			cellData += new BigDecimal(myCell.getNumericCellValue()).toString() + CVS_SEPERATOR_CHAR;
//			
//		}
//		
//		return cellData;
//		
//    }
	
//	private static String getFormulaValue(HSSFCell myCell) throws Exception {
//		
//		String cellData = "";
//		
//		if (myCell.getCachedFormulaResultType() == HSSFCell.CELL_TYPE_STRING || myCell.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN) {
//			
//			cellData += myCell.getRichStringCellValue() + CVS_SEPERATOR_CHAR;
//			
//		} else if (myCell.getCachedFormulaResultType() == HSSFCell.CELL_TYPE_NUMERIC) {
//			
//			cellData += getNumericValue(myCell) + CVS_SEPERATOR_CHAR;
//			
//		}
//		
//		return cellData;
//	}
	
	private static boolean checkValidFile(String fileName) {
		
		boolean valid = true;
		
		try {
			
			File f = new File(fileName);	
			if (!f.exists() || f.isDirectory()) {
				valid = false;
			}
			
		} catch (Exception e) {
			valid = false;
		}

		return valid;
	}

	public static void main(String arg[]) {
		String targetFilePath = "/Users/hyogun/workspace/01.android/pms-commons/target.xlsx";
		String targetFileDstPath = "/Users/hyogun/workspace/01.android/pms-commons/target.csv";
		
		try {
			ExcelDataConvertor.XSLXToCSV(targetFilePath, targetFileDstPath, "EUC-KR");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("end");
	}
}

