package com.humuson.tms.common.model.target;

import lombok.Data;
import lombok.experimental.Accessors;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.humuson.tms.common.util.StringUtils;

@Data
@Accessors(chain=true)
public class TargetData {
	public static final String POST_ID = "POST_ID";
	public static final String SEND_STATE = "SEND_STATE";
	public static final String CHNANEL_TYPE = "CHNANEL_TYPE";
	public static final String SERVER_ID = "SERVER_ID";
	public static final String TMS_M_ID = "TMS_M_ID";
	public static final String MEMBER_ID = "MEMBER_ID";
	public static final String TMS_M_EMAIL = "TMS_M_EMAIL";
	public static final String MEMBER_EMAIL = "MEMBER_EMAIL";
	public static final String TMS_M_PHONE = "TMS_M_PHONE";
	public static final String MEMBER_PHONE = "MEMBER_PHONE";
	public static final String TMS_M_TOKEN = "TMS_M_TOKEN";
	public static final String MEMBER_TOKEN = "MEMBER_TOKEN";
	
	public static final String TMS_M_NAME = "TMS_M_NAME";
	public static final String MEMBER_NAME = "MEMBER_NAME";
	
	public static final String DEVICE_ID = "DEVICE_ID";
	public static final String FIELD1 = "FIELD1";
	public static final String FIELD2 = "FIELD2";
	public static final String FIELD3 = "FIELD3";
	public static final String FIELD4 = "FIELD4";
	public static final String FIELD5 = "FIELD5";
	public static final String FIELD6 = "FIELD6";
	public static final String FIELD7 = "FIELD7";
	public static final String FIELD8 = "FIELD8";
	public static final String MKT_YN = "MKT_YN";
	
	private String postId;
	private int siteId;
	private String serverId = "01";
	private String chunkId;
	private String memberId;
	private String memberName;
	private String memberEmail;
	private String domain;
	private String memberPhone;
	private String telCode;
	private String memberToken;
	private String deviceId;
	private String field1;
	private String field2;
	private String field3;
	private String field4;
	private String field5;
	private String field6;
	private String field7;
	private String field8;
	private String channelType;
	private boolean isDbEncryptFlag;
	private boolean isSourceEncryptFlag;
	private String mktYn;
	private String duplicateKey;
	private String msgId;
	private String seqNo;
	private int appGrpId;
	private String os;
	
	public void setDbEncryptFlag(String flag) {
		isDbEncryptFlag = "Y".equals(flag) ? true : false;
	}
	
	public void setSourceEncryptFlag(String flag) {
		isSourceEncryptFlag = "Y".equals(flag) ? true : false;
	}
	
	public void put(String key, String value) throws Exception {
		value = StringUtils.removeBOM(value);
		if (TMS_M_ID.equals(key) || MEMBER_ID.equals(key)) {
			this.memberId = value;
		} else if (TMS_M_EMAIL.equals(key) || MEMBER_EMAIL.equals(key)) {
			this.memberEmail = value;
			this.domain = StringUtils.getDomain(this.memberEmail);
		} else if (TMS_M_PHONE.equals(key) || MEMBER_PHONE.equals(key)) {
			this.memberPhone = value;
			this.telCode = StringUtils.getTelNum1(memberPhone);
		} else if (TMS_M_TOKEN.equals(key) || MEMBER_TOKEN.equals(key)) {
			this.memberToken = value;
		} else if (TMS_M_NAME.equals(key) || MEMBER_NAME.equals(key)) {
			this.memberName = value;
		} else if (DEVICE_ID.equals(key)) {
			this.deviceId = value;
		} else if (FIELD1.equals(key)) {
			this.field1 = value;
		} else if (FIELD2.equals(key)) {
			this.field2 = value;
		} else if (FIELD3.equals(key)) {
			this.field3 = value;
		} else if (FIELD4.equals(key)) {
			this.field4 = value;
		} else if (FIELD5.equals(key)) {
			this.field5 = value;
		} else if (FIELD6.equals(key)) {
			this.field6 = value;
		} else if (FIELD7.equals(key)) {
			this.field7 = value;
		} else if (FIELD8.equals(key)) {
			this.field8 = value;
		} else if (MKT_YN.equals(key)) {
			this.mktYn = value;
		} else {
			throw new Exception("column name ["+key+"] not found!!");
		}
	}
	
	@Override
    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(this, style);
        return tsb.toString();
    }
}
