package com.humuson.tms.common.model.mq;


public enum MessageType {
	SCHEDULE(0X00),
	SNED(0x01); 
	
	private int code;

	private MessageType(int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
	
	public static MessageType valueOfCode(int code) throws IllegalArgumentException {
		for (MessageType eCode : MessageType.values()) {
			if (eCode.getCode() == code) {
				return eCode;
			}
		}

        throw new IllegalArgumentException("No enum constant " + code);
    }
}
