package com.humuson.tms.common.model;

import java.util.Date;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import lombok.Data;
import lombok.experimental.Accessors;

import com.humuson.tms.constrants.StatusType;

/**
 * 발송 채널별 발송에 필요한 정보를 가지고 있는 테이블.
 * TABLE : TMS_CHN_INFO
 * PK : POST_ID + CHANNEL_TYPE + CHANNEL_SEQ
 */
@Data
@Accessors(chain=true)
public class TmsChnInfo {

    private String postId;
    private String channelType;
    private String channelSeq = "01";
    private String contentHtml;
    private String contentText;
    private String contentType;
    private String jobStatus = StatusType.PENDDING.getCode();
    private String subject;
    private String pushType;
    private String pushTitle;
    private String pushValue;
    private String pushMsgTitle;
    private String pushMsgSubtitle;
    private String pushMsg;
    private String pushImg;
    private String bizId;
    private String msgGrpCd;
    private String fromName;
    private String fromEmail;
    private String fromNumber;
    private String returnPath;
    private String openCheck;
    private String clickCheck;
    private Date queCloseDate;
    private Date trackingClose;
    private Date modyDate;
    private Date regDate;
    private String regId;
    private String nlsLang;
    private String smsType;
    private String smartHtml;
    private String filterUseYn;
    private String redenyFlag;
    private String mailKind;
    private String autoUse;
    private String safemailYn;
    private String templateWidth;
    private String fatigability;
    
    @Override
    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(this, style);
        return tsb.toString();
    }
}