package com.humuson.tms.common.model;

import java.util.Random;

import com.humuson.tms.common.model.mq.PushSendType;
import com.humuson.tms.constrants.CommonType;

import lombok.Data;

@Data
public class CcsMessageId {
	
	String id;
	
	long pushId;
	long deviceId;
	String reqUid;
	String custId;
	int appGrpId;
	String serverId;
	String chunkId;
	PushSendType pushSendType;
	boolean isMqSending = false;
	CommonType commonSendType;
	
	public static final int MAX_CHUNK_SIZE = 10;
	
	public CcsMessageId(){
		Random rnd = new Random();
		chunkId = String.format("%02d", rnd.nextInt(MAX_CHUNK_SIZE)+1);
	}
	
	public void setPushSendType(PushSendType pushSendType){
		this.pushSendType = pushSendType;
		if(pushSendType.equals(PushSendType.MQ)){
			isMqSending = true;
		}
	}
	
}
