package com.humuson.tms.constrants;

/**
 * 
 * @author hyogun
 *
 */
public enum TargetType {
	SQL("SQL"),
	DB("DB"),
	FILE("FILE"),
	COND("COND"),
	REL("REL"),
	AMC("AMC")
	;
	
	final String code;

	TargetType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
    
    public boolean same(String status){
        return getCode().equals(status);
    }
    
    public static String findStatusCode(String code){
        if(code == null)return null;
        String value = null;
        for(TargetType status : values()){
            value = status.getCode();
            if(code.indexOf(value) >= 0)return value;
        }
        return null;
    }
}
