package com.humuson.tms.constrants;



/**
 * 채널타입
 */

public enum ChannelType {

    EMAIL("EM","Email"),
    KAKAO("KA","KakaoTalk"),
    PUSH("PU","Push"),
    SMS("SM","SMS"),
    LMS("LM","LMS"),
    TOTAL("TO","Total"),
    TWITTER("TW","Twitter"),
    FACEBOOK("FB","Facebook"),
    SMART_SMS("SS", "SmartSMS");

    final String code;
    final String name;

    ChannelType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }
    
    public String getName(){
    	return name;
    }
    
    public boolean same(String channelTypeCode){
        return getCode().equals(channelTypeCode);
    }
    
    public static ChannelType valueOfCode(String code) throws IllegalArgumentException {
		for (ChannelType eCode : ChannelType.values()) {
			if (eCode.getCode().equals(code)) {
				return eCode;
			}
		}

        throw new IllegalArgumentException("No enum constant " + code);
    }
    
    public static String findName(String code){
    	for(ChannelType channelType : values()){
    		if ( channelType.code.equals(code) ) {
    			return channelType.name;
    		}
        }
        return null;
    }
    
    public static String findChannelTypeCode(String str){
        if(str == null) return null;
        String typeValue = null;
        for(ChannelType channelType : values()){
            typeValue = channelType.getCode();
            if(str.indexOf(typeValue) >= 0) return typeValue;
        }
        return null;
    }
    
    public static void main(String[] args) {
//    	ChannelType chnType = ChannelType.valueOf("PU");
    	System.out.println(ChannelType.valueOfCode("PU").getCode());
	}
   
}
