/*
 * @(#).java            2004. 10. 27.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package com.humuson.tms.common.util;

import java.util.NoSuchElementException;

/**
 * One type of linked list created by amail Inc. This object follows 
 * the 'First In First Out' rule and often used when there occurs
 * plenty of 'In and Out' actions. 
 * 
 * @version		1.1
 * @author 		dragon
 *
 */
public class FIFOBuffer {
	
	
	private transient Entry header = new Entry(null, null, null);
	
	private transient int size = 0;
	
	private int maximumSize = -1;
	
	
	/**
	 * Creates new instance of FIFOBuffer
	 * @param max max size of this object
	 */
	public FIFOBuffer( int max ) {
		
		header.next = header.previous = header;
		maximumSize = max;
	}
	
	/**
	 * Changes max size
	 * @param max 
	 */
	public synchronized void reSize( int max ){
		
		maximumSize = max;
	}
	
	/**
	 * Checks if the FIFOBuffer instance contains the object
	 * @param obj
	 * @return if contains the object, true, else false
	 */
	public synchronized boolean contains( Object obj ) {
		
		return this.indexOf( obj ) > 0;
	}
	
	/**
	 * Puts the object in the FIFOBuffer instance
	 * @param obj
	 * @return
	 */
	public synchronized boolean push( Object obj ) {
		
		if( obj == null ) {
			throw new NullPointerException( "CAN NOT INSERT NULL" );
		}
		
		if( maximumSize > 0 && size >= maximumSize ) return false;
		
		addBefore(obj, header);
		
		return true;
	}
	
	/**
	 * Takes out the first element of the FIFOBuffer instance
	 * @return 
	 */
	public synchronized Object pop() {
		
		if (size==0) {
			return null;
		}
		
		Object first = header.next.element;
		remove(header.next);
		return first;
	}
	
	private void addBefore(Object o, Entry e) {
		Entry newEntry = new Entry(o, e, e.previous);
		newEntry.previous.next = newEntry;
		newEntry.next.previous = newEntry;
		size++;
	}
	
	/**
	 * @param o
	 * @return
	 */
	public synchronized boolean remove(Object o) {
		if (o==null) {
			return false;
		}
		
		for (Entry e = header.next; e != header; e = e.next) {
			if (o.equals(e.element)) {
				remove(e);
				return true;
			}
		}
		
		return false;
	}
	
	private void remove(Entry e) {
		if (e == header)
			throw new NoSuchElementException();
		
		e.previous.next = e.next;
		e.next.previous = e.previous;
		size--;
	}
	
	private int indexOf(Object o) {
		int index = 1;
		if (o==null) {
			return -1;
		}
		
		for (Entry e = header.next; e != header; e = e.next) {
			if (o.equals(e.element))
				return index;
			index++;
		}
		return -1;
	}
	
	
	/**
	 * Retrieves the size of the current buffer
	 * @return 
	 */
	public int size(){
		return size;
	}
	
	private static class Entry {
		Object element;
		Entry next;
		Entry previous;
		
		Entry(Object element, Entry next, Entry previous) {
			this.element = element;
			this.next = next;
			this.previous = previous;
		}
	}
}

