package com.humuson.tms.common.util;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ClassUtils;

@Slf4j
public class ConvertUtils {

	/** The Constant SIMPLE_TYPE_CONVERTER. */
	private static final TypeConverter SIMPLE_TYPE_CONVERTER = new ThreadSafedSimpleTypeConverter();

	/**
	 * Convert if necessary.
	 *
	 * @param <T>
	 *            the generic type
	 * @param value
	 *            the value
	 * @param requiredType
	 *            the required type
	 * @return the t
	 * @throws org.springframework.beans.TypeMismatchException
	 *             the type mismatch exception
	 */
	public static <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
		try {
			return SIMPLE_TYPE_CONVERTER.convertIfNecessary(value, requiredType);
		} catch (RuntimeException e) {
			log.error("Fail convert type. value:[" + value.toString() + "}, type:[" + ClassUtils.getQualifiedName(requiredType) + "]", e);
			throw e;
		}
	}
}
