package com.humuson.tms.common.util;

import org.apache.commons.lang3.math.NumberUtils;

/**
 * 
 * @author kimgungoo
 *
 */
public class CalculateUtils {
	
	/**
	 * 퍼센티지 구하는 메소드
	 * 가능하면 쿼리단에서 해결하기
	 * @param numerator 분자
	 * @param denominator 분모
	 * @return
	 */
	public static double getPercentage(double numerator, double denominator) {
		if (denominator == NumberUtils.DOUBLE_ZERO) {
			return denominator;
		}
		
		return (numerator / denominator * 100);
	}
	

	/**
	 * 소수점 몇째자리까지 구하기
	 * @param numerator
	 * @param denominator
	 * @param position 자릿수
	 * @return
	 */
	public static double getPercentage(double numerator, double denominator, int position) {
		double value = getPercentage(numerator, denominator);		
		double _position = Math.pow(10, position);
		
		return Math.round(value * _position) / _position;
	}
}
