package com.humuson.tms.common.security;


import org.apache.xmlbeans.impl.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.humuson.tms.common.zip.HumusonZip;

/**
 * humuson 암호화 클래스 
 * seed 128bit로 암호화를 수행함
 * @author hyogun
 *
 */
public class HumusonEncryptor {
	
	private static final Logger logger = LoggerFactory.getLogger(HumusonEncryptor.class);
	
	private static String FREEKEY = "Pg-s_E_n_C_k_e_y";
	
	public static String generateKey(String key) {
		
		String genKey = null;
		
		if( key == null ) {
			genKey = FREEKEY.substring(0,16);
		} else {
			
			if( key.length() > 16 ) {
				genKey = key.substring(0,16);
			} else {
				genKey = key + ( FREEKEY.substring(0,16-key.length())  );
			}
		}
		return genKey;
	}
	
	public static String encrypt(String str) {
		return encrypt(str, FREEKEY, "UTF-8");
	}

	public static String encrypt(String str, String userKey) {
		return encrypt(str, userKey, "UTF-8", true);
	}
	
	public static String encrypt(String str, String userKey, boolean useZip) {
		return encrypt(str, userKey, "UTF-8", useZip);
	}
	
	public static String encrypt(String str, String userKey, String charSet) {
		return encrypt(str, userKey, "UTF-8", true);
	}
	
	public static String encrypt(String str, String userKey, String charSet, boolean useZip) {
	
		String returnStr = "";

		if( str == null || userKey == null || charSet == null ) return returnStr;
		
		if (userKey.length() < 16) userKey = generateKey(userKey);
		else userKey = userKey.substring(0, 16);
		
		try {
			byte[] enc2 = null;
			
			if (useZip) {
				byte[] enc1 = HumusonZip.zipStringToBytes(str, charSet);
				enc2 = Seed.seedEncrypt(enc1, userKey.getBytes());
			} else {
				enc2 = Seed.seedEncrypt(str.getBytes(), userKey.getBytes());
			}

			returnStr = new String(Base64.encode(enc2), charSet);
			
		} catch(Exception e) {
			logger.error("encrypt error params[str:{}, userKey:{}, useZip:{}]", str, userKey, useZip, e);
		} finally {
			if (logger.isDebugEnabled()) {
				logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", returnStr, str, userKey, useZip);
			}
		}
		
		return returnStr;
	}
	
	public static void main(String[] args) {
		HumusonEncryptor humusonEncryptor = new HumusonEncryptor();
		String pmsIdEncKey = "humuson0722^^_^^";
		String phone = "12341234";
		String encStr = humusonEncryptor.encrypt(phone, pmsIdEncKey);
		System.out.println(encStr);
	}  
}
