package com.humuson.tms.common.model.target;

import lombok.Data;
import lombok.experimental.Accessors;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Data
@Accessors(chain=true)
public class TargetFileInfo {
	
	public static final String TARGET_FILE_NAME = "TARGET_FILE_NAME";
	public static final String TARGET_FILE_DELIM = "TARGET_FILE_DELIM";
	public static final String TARGET_FILE_IDX = "TARGET_FILE_IDX";
	public static final String TARGET_FILE_ENCODING = "TARGET_FILE_ENCODING";
	public static final String TARGET_FILE_HEAD_FLAG = "TARGET_FILE_HEAD_FLAG";
	public static final String APP_GRP_ID = "APP_GRP_ID";
	
	// file target
	private String fileIdx;
	private String fileName;
	private String fileDelim = "|";
	private String fileCharSet;
	private String targetFileHeadFlag = "N";
	private String linesToSkip;
	private int appGrpId;
	
	@Override
    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(this, style);
        return tsb.toString();
    }
}
