package com.humuson.tms.common.model.mq;

public enum SendType {
	APNS(0x00), GCM(0x01), PRIVATE(0x02), REPORT(0x03), KAKAO(0x04), UNKOWN(0x10);

	private int code;

	private SendType(int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
	
	public static SendType valueOfCode(int code) throws IllegalArgumentException {
		for (SendType eCode : SendType.values()) {
			if (eCode.getCode() == code) {
				return eCode;
			}
		}

        throw new IllegalArgumentException("No enum constant " + code);
    }
}
