/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.parallel.task;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.compress.ZipFileManager;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import pluto.log.Composer;
import pluto.log.Log;
import pluto.schedule.Task;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.popper.Popper;
import venus.spool.mass.basic.MassBasicDefaultMappingGenerator;

public abstract class SpoolControlTask
extends Task
implements Log {
    private static final Logger log = LoggerFactory.getLogger(SpoolControlTask.class);
    public static String SPOOL_WORKING_DIRECTORY = null;
    public static String SPOOL_WORKING_URL = null;
    public static int SPOOL_LIMIT = 100000;
    public static String DEFAULT_SINGLE_MAPPING_HEADER = null;
    protected String POST_ID = null;
    protected String CHANNEL_TYPE = null;
    protected String AB_ID = null;
    protected String REAL_POST_ID = null;
    protected boolean APPEND_TOTAL_SPOOL = false;
    protected eMsFileWriter BUFFERED_SPOOL_WRITER = null;
    protected String BUFFERED_SPOOL_WRITER_FILE_NAME = null;
    protected String BASE_BUFFERED_SPOOL_WRITER_FILE_NAME = null;
    protected boolean LIST_APPEND_FLAG = false;
    protected boolean COMPRESS_FLAG = false;
    protected boolean PARALLEL_FLAG = false;
    protected Vector PARALLEL_SERVER_NAME_LIST = new Vector();
    protected Properties PARALLEL_SERVER_SPOOLINFO = new Properties();
    protected String PARALLEL_SPOOL_CURRENT_SVRNAME = "";
    protected int PARALLEL_CURRENT_SVR_CNT = 0;
    protected int PARALLEL_CURRENT_SPOOL_CNT = 0;
    protected int SPOOL_ATTACH_COUNT = 0;
    protected int SPOOL_FILE_INDEX = 0;
    protected SpoolInfo mailSpoolInfo = null;
    protected Composer composer = null;
    protected SpoolAnalyzer SPOOL_ANALYZER = null;
    protected eMsFileWriter SPOOL_ERROR_STORE_WRITER = null;
    protected Popper SPOOL_POPPER = null;
    protected Vector SPOOL_FILE_LIST = new Vector();
    protected Vector SPOOL_FILE_URL_LIST = new Vector();
    protected Properties SPOOL_PARALLEL_FILE_URL_LIST = new Properties();
    protected String WORK_FILE_ID = null;
    protected Properties MAPPING_HEADER_INFO = null;

    public SpoolControlTask() throws Exception {
        this(1, 60000L);
    }

    public SpoolControlTask(short type) throws Exception {
        this(type, 60000L);
    }

    public SpoolControlTask(short type, long interval) throws Exception {
        super(type, interval);
        this.composer = Composer.getComposerInstance();
        this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
        this.SPOOL_FILE_LIST = new Vector();
        this.SPOOL_FILE_URL_LIST = new Vector();
        this.PARALLEL_SERVER_NAME_LIST = new Vector();
        this.PARALLEL_SERVER_SPOOLINFO = new Properties();
        this.SPOOL_PARALLEL_FILE_URL_LIST = new Properties();
        this.COMPRESS_FLAG = "true".equals(eMsSystem.getProperty("spool.compress"));
    }

    public void setParallelInfo(boolean parallelFlag, String svrPerInfo) throws Exception {
        this.PARALLEL_FLAG = parallelFlag;
        if (this.PARALLEL_FLAG) {
            StringTokenizer st2;
            StringTokenizer st = new StringTokenizer(svrPerInfo, "=");
            int svrCnt = 0;
            if (st.hasMoreTokens()) {
                st2 = new StringTokenizer(st.nextToken().trim(), ":");
                while (st2.hasMoreTokens()) {
                    this.PARALLEL_SERVER_NAME_LIST.add(svrCnt++, st2.nextToken().trim());
                }
            }
            if (st.hasMoreTokens()) {
                st2 = new StringTokenizer(st.nextToken().trim(), ":");
                for (int i = 0; i < svrCnt; ++i) {
                    if (st2.hasMoreTokens()) {
                        this.PARALLEL_SERVER_SPOOLINFO.setProperty((String)this.PARALLEL_SERVER_NAME_LIST.get(i), st2.nextToken().trim());
                        continue;
                    }
                    this.PARALLEL_SERVER_SPOOLINFO.setProperty((String)this.PARALLEL_SERVER_NAME_LIST.get(i), "0");
                }
            }
        }
    }

    protected void openSpooler(String filename) throws Exception {
        this.closeSpooler();
        this.BUFFERED_SPOOL_WRITER = new eMsFileWriter(filename);
        this.BUFFERED_SPOOL_WRITER_FILE_NAME = filename;
        this.BASE_BUFFERED_SPOOL_WRITER_FILE_NAME = filename;
        this.LIST_APPEND_FLAG = false;
    }

    protected String openNextSpooler() throws Exception {
        this.closeSpooler();
        this.BUFFERED_SPOOL_WRITER_FILE_NAME = this.BASE_BUFFERED_SPOOL_WRITER_FILE_NAME.concat(".").concat(String.valueOf(this.SPOOL_FILE_INDEX++));
        this.BUFFERED_SPOOL_WRITER = new eMsFileWriter(this.BUFFERED_SPOOL_WRITER_FILE_NAME, false);
        return this.BUFFERED_SPOOL_WRITER_FILE_NAME;
    }

    protected void appendSpooler(String spool) throws Exception {
        this.BUFFERED_SPOOL_WRITER.write(spool);
        this.BUFFERED_SPOOL_WRITER.newLine();
        this.BUFFERED_SPOOL_WRITER.flush();
        this.LIST_APPEND_FLAG = true;
    }

    protected void closeSpooler() {
        if (this.BUFFERED_SPOOL_WRITER != null) {
            try {
                this.BUFFERED_SPOOL_WRITER.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.BUFFERED_SPOOL_WRITER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String realFileName = this.BUFFERED_SPOOL_WRITER_FILE_NAME;
            if (this.LIST_APPEND_FLAG) {
                if (this.COMPRESS_FLAG) {
                    int i = this.BUFFERED_SPOOL_WRITER_FILE_NAME.lastIndexOf("/");
                    String base = i == -1 ? "" : this.BUFFERED_SPOOL_WRITER_FILE_NAME.substring(0, i);
                    String fileName = this.BUFFERED_SPOOL_WRITER_FILE_NAME.substring(i + 1);
                    try {
                        realFileName = ZipFileManager.makeZip(base, fileName, false);
                    }
                    catch (Exception ex) {
                        log.error(" Error while creating zip file - " + this.BUFFERED_SPOOL_WRITER_FILE_NAME);
                    }
                }
            } else {
                return;
            }
            String __SPOOL_FILE_URL_NAME__ = SPOOL_WORKING_URL + "/" + realFileName.substring(SPOOL_WORKING_DIRECTORY.length() + 1);
            if (this.PARALLEL_FLAG) {
                this.SPOOL_FILE_LIST.addElement(realFileName);
                this.SPOOL_PARALLEL_FILE_URL_LIST.setProperty(this.PARALLEL_SPOOL_CURRENT_SVRNAME + "|" + this.PARALLEL_CURRENT_SPOOL_CNT, __SPOOL_FILE_URL_NAME__);
                ++this.PARALLEL_CURRENT_SPOOL_CNT;
            } else {
                this.SPOOL_FILE_LIST.addElement(realFileName);
                this.SPOOL_FILE_URL_LIST.addElement(__SPOOL_FILE_URL_NAME__);
            }
            if (log.isDebugEnabled()) {
                log.debug(" Spool Registered : " + realFileName);
            }
            if (this.LIST_APPEND_FLAG) {
                return;
            }
            try {
                boolean fileDel = new File(this.BUFFERED_SPOOL_WRITER_FILE_NAME).delete();
                if (!fileDel) {
                    log.error("File deletion failed");
                }
                this.BUFFERED_SPOOL_WRITER = null;
            }
            catch (Exception e) {
                log.error(this.BUFFERED_SPOOL_WRITER_FILE_NAME, (Throwable)e);
            }
        }
    }

    protected void deleteSpooler() {
        if (this.BUFFERED_SPOOL_WRITER != null) {
            try {
                this.BUFFERED_SPOOL_WRITER.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.BUFFERED_SPOOL_WRITER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.BUFFERED_SPOOL_WRITER = null;
            try {
                boolean fileDel = new File(this.BUFFERED_SPOOL_WRITER_FILE_NAME).delete();
                if (!fileDel) {
                    log.error("File deletion failed");
                }
            }
            catch (Exception e) {
                log.error(this.BUFFERED_SPOOL_WRITER_FILE_NAME, (Throwable)e);
            }
        }
    }

    @Override
    public void release_Resource() {
        this.closeSpooler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        boolean success = true;
        Exception x = null;
        try {
            this.execute_Startup();
            this.makeSpoolFile();
            this.makeSpoolInfo();
        }
        catch (Exception ex) {
            success = false;
            x = ex;
        }
        finally {
            this.execute_Finish(success);
        }
        if (x != null) {
            throw x;
        }
    }

    public SpoolInfo getSpoolInfo() {
        return this.mailSpoolInfo;
    }

    protected String getMappingHeader() throws Exception {
        String value = this.TASK_PROPERTY.getProperty("MAPPINGHEADER");
        if (value == null || value.trim().equals("null") || value.trim().equals("")) {
            return DEFAULT_SINGLE_MAPPING_HEADER;
        }
        return value;
    }

    protected void makeSpoolInfo() throws Exception {
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.TASK_PROPERTY.getProperty("POST_ID"));
        this.mailSpoolInfo.setSendState(this.TASK_PROPERTY.getProperty("SEND_STATE"));
        this.mailSpoolInfo.setMappingHeader(this.getMappingHeader());
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_URL_LIST);
        MassBasicDefaultMappingGenerator KEYVALUE_MAPPING_GENERATOR = new MassBasicDefaultMappingGenerator();
        KEYVALUE_MAPPING_GENERATOR.process(this.TASK_PROPERTY);
        this.mailSpoolInfo.setDefaultMapping(KEYVALUE_MAPPING_GENERATOR.getMapOfDefaultMapping());
        if (this.PARALLEL_FLAG) {
            this.mailSpoolInfo.setSpoolParallelFilesInfo(this.SPOOL_PARALLEL_FILE_URL_LIST);
            for (int i = 0; i < this.PARALLEL_SERVER_NAME_LIST.size(); ++i) {
                SpoolInfoManager.registParallelSpoolInfo(this.mailSpoolInfo, (String)this.PARALLEL_SERVER_NAME_LIST.get(i));
            }
        } else {
            SpoolInfoManager.registSpoolInfo(this.mailSpoolInfo);
        }
    }

    public void makeSpoolFile() throws Exception {
        String this_day = Cal.getDayDate();
        String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".spool";
        try {
            this.openSpooler(__SPOOL_FILE_NAME__);
            if (log.isDebugEnabled()) {
                log.debug("OPEN Spool=>" + __SPOOL_FILE_NAME__);
            }
            if (this.PARALLEL_FLAG) {
                this.execute_Parallel_ListLoad(this.TASK_PROPERTY);
            } else {
                this.execute_ListLoad(this.TASK_PROPERTY);
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Object)e.toString());
            throw e;
        }
        finally {
            this.closeSpooler();
            if (!this.LIST_APPEND_FLAG) {
                this.deleteSpooler();
                if (log.isDebugEnabled()) {
                    log.debug("NO APPEND LIST FILE");
                }
            }
        }
    }

    protected void execute_ListLoad(Properties prop) throws Exception {
    }

    protected void execute_Parallel_ListLoad(Properties prop) throws Exception {
    }

    protected void execute_Startup() throws Exception {
    }

    protected void execute_Finish(boolean b) throws Exception {
    }

    protected abstract void addSpool(Properties var1) throws Exception;

    public void setMAPPING_HEADER_INFO(Properties prop) {
        if (prop != null) {
            this.MAPPING_HEADER_INFO = new Properties();
            this.MAPPING_HEADER_INFO.putAll((Map<?, ?>)prop);
        }
    }

    static {
        try {
            SPOOL_WORKING_DIRECTORY = eMsSystem.getProperty("spool.store.directory");
            SPOOL_WORKING_URL = eMsSystem.getProperty("spool.store.url");
            SPOOL_LIMIT = Integer.parseInt(eMsSystem.getProperty("spool.limit", "100000"));
            DEFAULT_SINGLE_MAPPING_HEADER = eMsSystem.getProperty("default.single.mapping.header");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

