/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.parallel.task;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import venus.spool.parallel.task.SpoolControlTask;

public abstract class AbstractDbSpoolTask
extends SpoolControlTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbSpoolTask.class);
    protected String LIST_TABLE = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected StringBuffer TMP_STRING_BUFFER = null;
    protected String SELECT_TARGET_LIST_QUERY = null;
    protected String UPDATE_TARGET_LIST_QUERY = null;
    protected int __TARGET_CNT = 0;

    public AbstractDbSpoolTask() throws Exception {
        super((short)1, 60000L);
    }

    public AbstractDbSpoolTask(short type) throws Exception {
        super(type, 60000L);
    }

    public AbstractDbSpoolTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        if (log.isDebugEnabled()) {
            log.debug(" Request Connection");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        if (log.isDebugEnabled()) {
            log.debug(" Get Connetion " + this.EMS_CONNECTION.getName());
        }
        this.TMP_STRING_BUFFER = new StringBuffer(1024);
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
        this.TMP_STRING_BUFFER = null;
    }

    @Override
    protected void execute_ListLoad(Properties TARGET_PROPERTIES) throws Exception {
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsStatement __UPDATE_STATEMENT__ = null;
        eMsResultSet rs = null;
        Exception ex = null;
        try {
            __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            __UPDATE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
            rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
            Properties TARGET_INFO = new Properties();
            while (rs.next()) {
                TARGET_INFO.clear();
                rs.putToMap(TARGET_INFO, this.APPEND_TOTAL_SPOOL);
                if (this.UPDATE_TARGET_LIST_QUERY != null) {
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_TARGET_LIST_QUERY, TARGET_INFO, "${", "}", true, false);
                    if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                        log.error("list update fail");
                        continue;
                    }
                }
                if (this.SPOOL_ATTACH_COUNT++ > SPOOL_LIMIT) {
                    this.SPOOL_ATTACH_COUNT = 0;
                    String __NEXT_SPOOL_FILE_NAME__ = this.openNextSpooler();
                    log.debug("SWITCH SPOOL", (Object)__NEXT_SPOOL_FILE_NAME__);
                }
                TARGET_INFO.setProperty("REAL_POST_ID", TARGET_PROPERTIES.getProperty("REAL_POST_ID"));
                this.addSpool(TARGET_INFO);
                this.LIST_APPEND_FLAG = true;
            }
        }
        catch (Exception e) {
            log.error("spool make error", (Throwable)e);
            ex = e;
            throw ex;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            this.EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
            this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
        }
    }

    @Override
    protected void execute_Parallel_ListLoad(Properties TARGET_PROPERTIES) throws Exception {
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsStatement __UPDATE_STATEMENT__ = null;
        eMsResultSet rs = null;
        Exception ex = null;
        try {
            __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            __UPDATE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
            rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
            Properties TARGET_INFO = new Properties();
            int currentSpoolCnt = this.Parallel_Svr_Cnt();
            int sPoolParallelCnt = 0;
            while (rs.next()) {
                TARGET_INFO.clear();
                rs.putToMap(TARGET_INFO, this.APPEND_TOTAL_SPOOL);
                if (this.UPDATE_TARGET_LIST_QUERY != null) {
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_TARGET_LIST_QUERY, TARGET_INFO, "${", "}", true, false);
                    if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                        log.error("list update fail");
                        continue;
                    }
                }
                ++this.SPOOL_ATTACH_COUNT;
                if (this.SPOOL_ATTACH_COUNT > SPOOL_LIMIT || ++sPoolParallelCnt > currentSpoolCnt) {
                    this.SPOOL_ATTACH_COUNT = 0;
                    String __NEXT_SPOOL_FILE_NAME__ = this.openNextSpooler();
                    log.debug("SWITCH SPOOL", (Object)__NEXT_SPOOL_FILE_NAME__);
                    if (sPoolParallelCnt > currentSpoolCnt) {
                        sPoolParallelCnt = 0;
                        currentSpoolCnt = this.Parallel_Svr_Cnt();
                    }
                }
                TARGET_INFO.setProperty("REAL_POST_ID", TARGET_PROPERTIES.getProperty("REAL_POST_ID"));
                this.addSpool(TARGET_INFO);
                this.LIST_APPEND_FLAG = true;
            }
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
            log.info(e.toString());
            ex = e;
            throw ex;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            this.EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
            this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
        }
    }

    protected int Parallel_Svr_Cnt() throws Exception {
        int svrParlPer;
        int rsCnt;
        if (this.PARALLEL_CURRENT_SVR_CNT < this.PARALLEL_SERVER_NAME_LIST.size()) {
            this.PARALLEL_SPOOL_CURRENT_SVRNAME = (String)this.PARALLEL_SERVER_NAME_LIST.get(this.PARALLEL_CURRENT_SVR_CNT++);
        }
        if ((rsCnt = (svrParlPer = Integer.parseInt(this.PARALLEL_SERVER_SPOOLINFO.getProperty(this.PARALLEL_SPOOL_CURRENT_SVRNAME))) * this.__TARGET_CNT / 100) < 1) {
            rsCnt = 1;
        }
        return rsCnt;
    }
}

