/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.FileElement;
import pluto.util.Cal;
import pluto.util.StringUtil;
import venus.spool.mass.task.SingleTestSpoolTask;

public class BulkTestSpoolTask
extends SingleTestSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(BulkTestSpoolTask.class);

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.setTaskID(this.POST_ID.concat("_TEST"));
        this.setName(this.POST_ID + "_BulkTestSpoolTask");
        this.setSeq(this.TASK_PROPERTY.getProperty("SEQ"));
        this.WORK_FILE_ID = this.POST_ID.concat("_bulk_test_").concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setSendType("MTEST");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("N");
        this.SPOOL_ANALYZER.setLimitDate("19000101");
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    public void makeSpoolFile() throws Exception {
        String this_day = Cal.getDayDate();
        String __WORK_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + "_test.spool";
        if (log.isDebugEnabled()) {
            log.debug("spool filename:" + __WORK_FILE_NAME__);
        }
        this.openSpooler(__WORK_FILE_NAME__);
        List __TARGET_EMAILS__ = StringUtil.toStringList(this.TASK_PROPERTY.getProperty("TEST_LIST"), ":", new LinkedList());
        if (__TARGET_EMAILS__ == null || __TARGET_EMAILS__.size() < 1) {
            throw new RuntimeException("NO TEST LIST...");
        }
        Iterator iter = __TARGET_EMAILS__.iterator();
        while (iter.hasNext()) {
            String _TARGET_EMAIL_ = iter.next().toString();
            if (StringUtil.isError(_TARGET_EMAIL_)) continue;
            this.SPOOL_ANALYZER.setTokenID(_TARGET_EMAIL_);
            this.SPOOL_ANALYZER.setMemberID("testID");
            this.appendSpooler(this.SPOOL_ANALYZER.composeMultiRcptSend());
        }
        this.closeSpooler();
    }
}

