/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcptInfoHashList {
    private static final Logger log = LoggerFactory.getLogger(RcptInfoHashList.class);
    static final int DEFAULT_INITIAL_CAPACITY = 100;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static Hashtable __INNER_SINGLE_INFORM__ = null;
    private static Hashtable __INNER_MULTI_INFORM__ = null;
    private static int __SINGLE_DEFAULT_SIZE__ = 10;
    private static int __MULTI_DEFAULT_SIZE__ = 20;
    public static final DomainEntry EMPTY_DOMAIN_ENTRY = new DomainEntry();
    transient DomainEntry[] table;
    transient int size;
    int threshold;
    final float loadFactor;

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        __INNER_SINGLE_INFORM__ = new Hashtable();
        __INNER_MULTI_INFORM__ = new Hashtable();
        Enumeration<?> a = prop.propertyNames();
        while (a.hasMoreElements()) {
            String key = a.nextElement().toString();
            String value = prop.getProperty(key);
            try {
                if (key.startsWith("s.")) {
                    __INNER_SINGLE_INFORM__.put(key.substring(2), Integer.valueOf(value));
                    continue;
                }
                if (!key.startsWith("m.")) continue;
                __INNER_MULTI_INFORM__.put(key.substring(2), Integer.valueOf(value));
            }
            catch (Exception e) {
                log.error("DOMAIN KEY SETTING ERROR", (Throwable)e);
            }
        }
        __SINGLE_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("default.single", "10"));
        __MULTI_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("default.multi", "10"));
        log.error("SINGLE SETTING" + __INNER_SINGLE_INFORM__.toString());
        log.error("MULTI SETTING" + __INNER_MULTI_INFORM__.toString());
    }

    static final int getSingleSize(String domain) {
        if (domain == null) {
            return -1;
        }
        Integer ReturnValue = (Integer)__INNER_SINGLE_INFORM__.get(domain);
        if (ReturnValue != null) {
            return ReturnValue;
        }
        return __SINGLE_DEFAULT_SIZE__;
    }

    static final int getMultipleSize(String domain) {
        if (domain == null) {
            return -1;
        }
        Integer ReturnValue = (Integer)__INNER_MULTI_INFORM__.get(domain);
        if (ReturnValue != null) {
            return ReturnValue;
        }
        return __MULTI_DEFAULT_SIZE__;
    }

    public RcptInfoHashList(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new DomainEntry[capacity];
    }

    public RcptInfoHashList(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public RcptInfoHashList() {
        this.loadFactor = 0.75f;
        this.threshold = 75;
        this.table = new DomainEntry[100];
    }

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    void minusSize() {
        --this.size;
    }

    public DomainEntry put(String domain, int step, String mid, String email, String mapping, String etc) {
        DomainEntry newEntry;
        DomainEntry checkEntry;
        if (domain == null) {
            if (log.isDebugEnabled()) {
                log.debug("Domain Is Null");
                Exception e = new Exception("DEBUG");
                log.error("Exception", (Throwable)e);
            }
            return null;
        }
        int hash = RcptInfoHashList.hash(domain);
        int i = RcptInfoHashList.indexFor(hash, this.table.length);
        DomainEntry prevEntry = checkEntry = this.table[i];
        while (checkEntry != null) {
            if (checkEntry.hash == hash && RcptInfoHashList.eq(domain, checkEntry.domain)) {
                if (checkEntry.addListEntry(step, mid, email, mapping, etc)) {
                    if (prevEntry == checkEntry) {
                        this.table[i] = checkEntry.next;
                    } else {
                        prevEntry.next = checkEntry.next;
                    }
                    return checkEntry;
                }
                return EMPTY_DOMAIN_ENTRY;
            }
            prevEntry = checkEntry;
            checkEntry = checkEntry.next;
        }
        int newLimit = mapping == null ? RcptInfoHashList.getMultipleSize(domain) : RcptInfoHashList.getSingleSize(domain);
        this.table[i] = newEntry = new DomainEntry(hash, domain, this.table[i], newLimit);
        newEntry.addListEntry(step, mid, email, mapping, etc);
        ++this.size;
        if (this.size > this.threshold) {
            return null;
        }
        return EMPTY_DOMAIN_ENTRY;
    }

    public HashListIterator getIterator() {
        return new HashListIterator(this);
    }

    public static class ListEntry {
        public ListEntry next;
        public ListEntry previous;
        public String TMS_M_ID;
        public String TMS_M_TOKEN;
        public String MAPPING;
        public String ETC_INFOS;
        public int step;
        public short status;

        ListEntry(int s, String mid, String token, String mapping, String etc, ListEntry next, ListEntry previous) {
            this.TMS_M_ID = mid;
            this.TMS_M_TOKEN = token;
            this.MAPPING = mapping;
            this.ETC_INFOS = etc;
            this.step = s;
            this.next = next;
            this.previous = previous;
            this.status = (short)-1;
        }

        ListEntry() {
            this.next = this;
            this.previous = this;
        }
    }

    public static class DomainEntry {
        public String POST_ID = null;
        public String SEND_KIND = null;
        public String MAIL_FROM = null;
        public String LIST_TABLE = null;
        final String domain;
        final int hash;
        ListEntry headOfList;
        DomainEntry next;
        int size;
        int limit;

        DomainEntry() {
            this.domain = null;
            this.hash = -1;
        }

        DomainEntry(int hashValue, String d, DomainEntry n, int l) {
            this.domain = d;
            this.next = n;
            this.hash = hashValue;
            this.headOfList = new ListEntry();
            this.size = 0;
            this.limit = l;
        }

        public void setPOST_ID(String pid) {
            this.POST_ID = pid;
        }

        public void setSEND_KIND(String kind) {
            this.SEND_KIND = kind;
        }

        public void setMAIL_FROM(String mailfrom) {
            this.MAIL_FROM = mailfrom;
        }

        public void setLIST_TABLE(String listTable) {
            this.LIST_TABLE = listTable;
        }

        public String getDomain() {
            return this.domain;
        }

        public ListEntry getListEntry() {
            return this.headOfList;
        }

        public synchronized boolean addListEntry(int step, String mid, String email, String mapping, String etc) {
            ListEntry newEntry;
            this.headOfList.previous.next = newEntry = new ListEntry(step, mid, email, mapping, etc, this.headOfList, this.headOfList.previous);
            this.headOfList.previous = newEntry;
            return this.size++ > this.limit;
        }

        public int hashCode() {
            return this.domain.hashCode() ^ this.headOfList.hashCode();
        }

        public String toString() {
            return this.domain + " entry";
        }
    }

    public static class HashListIterator {
        private int current_check_index = -1;
        RcptInfoHashList owner = null;

        HashListIterator(RcptInfoHashList list) {
            this.owner = list;
            this.current_check_index = 0;
        }

        public DomainEntry nextEntry() {
            DomainEntry[] table = this.owner.table;
            DomainEntry target = null;
            while (this.current_check_index < table.length && (target = table[this.current_check_index]) == null) {
                ++this.current_check_index;
            }
            if (target == null) {
                return null;
            }
            table[this.current_check_index] = target.next;
            this.owner.minusSize();
            return target;
        }
    }
}

