/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.handler;

import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.HeadTailFilenameFilter;
import pluto.io.eMsFileWriter;
import pluto.util.Cal;
import venus.spool.common.handler.Spooler;

public class StandardSpooler
implements Spooler {
    private static final Logger log = LoggerFactory.getLogger(StandardSpooler.class);
    public static final String name = "StandardSpooler";
    public static final long DEFAULT_STORE_TIME = 1800000L;
    public static final int DEFAULT_MAX_STORE_COUNT = 10000;
    public static long STORE_TIME = 1800000L;
    public static int MAX_STORE_COUNT = 10000;
    private static String STORE_BASE_DIR = null;
    private static String STORE_WORK_FILE_HEADER = null;
    private static String STORE_WORK_FILE_EXT = null;
    private static String STORE_WAIT_FILE_HEADER = null;
    private static String STORE_WAIT_FILE_EXT = null;
    private static String STORE_WORKING_FILE_HEADER = null;
    private static String STORE_WORKING_FILE_EXT = null;
    private eMsFileWriter writer = null;
    private String current_spool_file = null;
    private int spool_count = 0;
    private long create_time = System.currentTimeMillis();

    public static void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        STORE_BASE_DIR = tmp.getProperty("work.dir");
        if (STORE_BASE_DIR == null) {
            throw new RuntimeException("store.dir param is not set... ");
        }
        try {
            STORE_TIME = Long.parseLong(tmp.getProperty("max.age")) * 60L * 1000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("MAX AGE:" + STORE_TIME);
        }
        STORE_WORK_FILE_HEADER = tmp.getProperty("work.file.header", "ResendQue");
        STORE_WORK_FILE_EXT = tmp.getProperty("work.file.ext", ".spooling");
        STORE_WAIT_FILE_HEADER = tmp.getProperty("wait.file.header", "Resending");
        STORE_WAIT_FILE_EXT = tmp.getProperty("wait.file.ext", ".work");
        STORE_WORKING_FILE_HEADER = tmp.getProperty("send.file.header", "QueProcess");
        STORE_WORKING_FILE_EXT = tmp.getProperty("send.file.ext", ".sending");
        try {
            MAX_STORE_COUNT = Integer.parseInt(tmp.getProperty("store.limit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("MAX_STORE_COUNT:" + MAX_STORE_COUNT);
        }
        log.debug("DELETE BEFORE WORKING FILES");
        HeadTailFilenameFilter workingFileFilter = new HeadTailFilenameFilter(STORE_WORKING_FILE_HEADER, STORE_WORKING_FILE_EXT);
        File base = new File(STORE_BASE_DIR);
        String[] working_files = base.list(workingFileFilter);
        for (int i = 0; i < working_files.length; ++i) {
            File source;
            boolean fileDel;
            String tmpFilename = STORE_BASE_DIR + File.separator + working_files[i];
            if (log.isDebugEnabled()) {
                log.debug("StandardSpooler before working file delete=>" + tmpFilename);
            }
            if (fileDel = (source = new File(tmpFilename)).delete()) continue;
            log.error("File deletion failed");
        }
        log.debug("RENAME BEFORE SPOOLING FILES");
        HeadTailFilenameFilter tmpFilter = new HeadTailFilenameFilter(STORE_WORK_FILE_HEADER, STORE_WORK_FILE_EXT);
        File dir = new File(STORE_BASE_DIR);
        String[] files = dir.list(tmpFilter);
        for (int i = 0; i < files.length; ++i) {
            String TargetFileName;
            File target;
            String tmpFilename = STORE_BASE_DIR + File.separator + files[i];
            File source = new File(tmpFilename);
            boolean fileRename = source.renameTo(target = new File(TargetFileName = STORE_BASE_DIR + File.separator + STORE_WAIT_FILE_HEADER + Cal.getSerialDate() + STORE_WAIT_FILE_EXT));
            if (!fileRename) {
                log.error("File name rename failed");
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getName() {
        return name;
    }

    @Override
    public void clean() {
        try {
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void addSpool(Object spool) throws Exception {
        if (spool == null) {
            return;
        }
        if (this.writer == null) {
            this.current_spool_file = STORE_BASE_DIR + File.separator + STORE_WORK_FILE_HEADER + Cal.getSerialDate() + STORE_WORK_FILE_EXT;
            this.writer = new eMsFileWriter(this.current_spool_file);
            this.create_time = System.currentTimeMillis();
            this.spool_count = 0;
        }
        if (this.writer != null) {
            try {
                this.writer.println(spool.toString());
                this.writer.flush();
                ++this.spool_count;
            }
            catch (Exception e) {
                log.error("SPOOLER", (Throwable)e);
                try {
                    this.writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.writer = new eMsFileWriter(this.current_spool_file, true);
                this.writer.println(spool.toString());
                this.writer.flush();
                ++this.spool_count;
            }
        }
        if (this.spool_count > MAX_STORE_COUNT) {
            this.switchSpool();
        }
    }

    @Override
    public boolean storeNext() {
        if (log.isDebugEnabled()) {
            log.debug("[Spooler] check next current : " + this.spool_count + " create time: " + this.create_time + " now : " + System.currentTimeMillis());
            log.debug("result:" + (System.currentTimeMillis() - this.create_time > STORE_TIME));
        }
        log.info("[Spooler] check next current : " + this.spool_count + " create time: " + this.create_time + " now : " + System.currentTimeMillis());
        if (this.spool_count == 0) {
            this.create_time = System.currentTimeMillis();
        }
        return System.currentTimeMillis() - this.create_time > STORE_TIME;
    }

    @Override
    public synchronized void switchSpool() throws Exception {
        try {
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.wait(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            File tmpFile = new File(this.current_spool_file);
            String swap_filename = STORE_BASE_DIR + File.separator + STORE_WAIT_FILE_HEADER + Cal.getSerialDate() + STORE_WAIT_FILE_EXT;
            if (!tmpFile.renameTo(new File(swap_filename))) {
                log.info("SWAPING FILE FAIL:" + this.current_spool_file + "=>" + swap_filename);
            }
            tmpFile = null;
            this.current_spool_file = STORE_BASE_DIR + File.separator + STORE_WORK_FILE_HEADER + Cal.getSerialDate() + STORE_WORK_FILE_EXT;
            this.writer = new eMsFileWriter(this.current_spool_file);
            this.create_time = System.currentTimeMillis();
            this.spool_count = 0;
        }
        catch (Exception e) {
            log.error("SPOOLER", (Throwable)e);
            this.writer = null;
        }
    }
}

