/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongMappingSpoolReader {
    private static final Logger log = LoggerFactory.getLogger(LongMappingSpoolReader.class);
    private static Hashtable INNER_CONTAINER = null;
    private static final int CONTAIN_LIMIT = 10;
    public static final int __BUFFER_SIZE__ = 4096;
    private static IOException INTEREX;
    private long LAST_EXEC_TIME = -1L;
    private RandomAccessFile INNER_READER = null;
    private String ID = "^^";
    private byte[] __INNER_BUFFER__ = new byte[4096];

    public static final synchronized LongMappingSpoolReader getInstance(String KEY) throws Exception {
        LongMappingSpoolReader returnValue = (LongMappingSpoolReader)INNER_CONTAINER.get(KEY);
        if (returnValue != null) {
            return returnValue;
        }
        if (INNER_CONTAINER.size() < 10) {
            returnValue = new LongMappingSpoolReader();
            if (returnValue != null) {
                returnValue.setTargetFile(KEY);
            }
            INNER_CONTAINER.put(returnValue.getID(), returnValue);
            return returnValue;
        }
        long __COMPARE_TIME__ = System.currentTimeMillis();
        Enumeration ENUM = INNER_CONTAINER.elements();
        while (ENUM.hasMoreElements()) {
            LongMappingSpoolReader tmpReader = (LongMappingSpoolReader)ENUM.nextElement();
            if (__COMPARE_TIME__ <= tmpReader.getLastTime()) continue;
            __COMPARE_TIME__ = tmpReader.getLastTime();
            returnValue = tmpReader;
        }
        if (returnValue != null) {
            INNER_CONTAINER.remove(returnValue.getID());
            returnValue.setTargetFile(KEY);
            INNER_CONTAINER.put(returnValue.getID(), returnValue);
        }
        return returnValue;
    }

    private LongMappingSpoolReader() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    private void setTargetFile(String filename) throws Exception {
        if (this.INNER_READER != null) {
            this.INNER_READER.close();
        }
        this.INNER_READER = new RandomAccessFile(filename, "r");
        this.ID = filename;
    }

    private String getID() {
        return this.ID;
    }

    private long getLastTime() {
        return this.LAST_EXEC_TIME;
    }

    public synchronized void inner_get(long __START__, long __END__, OutputStream __OUT_BUFFER__) throws Exception {
        this.LAST_EXEC_TIME = System.currentTimeMillis();
        this.INNER_READER.seek(__START__);
        for (long __LENGTH__ = __END__ - __START__; __LENGTH__ > 0L; __LENGTH__ -= 4096L) {
            int size;
            if (__LENGTH__ > 4096L) {
                size = this.INNER_READER.read(this.__INNER_BUFFER__);
                if (size != 4096) {
                    throw INTEREX;
                }
                __OUT_BUFFER__.write(this.__INNER_BUFFER__);
                continue;
            }
            size = this.INNER_READER.read(this.__INNER_BUFFER__, 0, (int)__LENGTH__);
            if (size != (int)__LENGTH__) {
                throw INTEREX;
            }
            __OUT_BUFFER__.write(this.__INNER_BUFFER__, 0, size);
        }
    }

    static {
        INNER_CONTAINER = new Hashtable();
        INTEREX = new IOException("FileRead is Interrupted");
    }
}

