/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.basic;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.schedule.ScheduledMonitor;
import venus.spool.common.basic.SpoolInfo;

public class SpoolInfoManager
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(SpoolInfoManager.class);
    public static final long CHECK_INTERVAL = 60000L;
    private static String INFO_SAVE_BASE_DIR = null;
    private static String INFO_SAVE_BASE_URL = null;
    private static String INFO_SAVE_FILE_EXT = null;
    private static String INFO_DTD_LOCATION = null;
    private static String INFO_XML_CHARSET = null;
    private static String INFO_XML_OUT_CHARSET = null;
    public static Object lock = new Object();
    private static Hashtable SPOOL_INFO_HASH = null;
    public static String name = "SpoolInfoManager";
    private static SpoolInfoManager INNER_MANAGER = null;
    private static Hashtable PARALLEL_SVR_SPOOLINFO = null;

    public static synchronized void unload() throws Exception {
        INNER_MANAGER.close();
    }

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        INFO_SAVE_BASE_DIR = tmp.getProperty("base.dir");
        INFO_SAVE_BASE_URL = tmp.getProperty("base.url");
        INFO_SAVE_FILE_EXT = tmp.getProperty("file.ext", ".xml");
        INFO_DTD_LOCATION = tmp.getProperty("dtd.location");
        INFO_XML_CHARSET = tmp.getProperty("info.xml.charset", "euc-kr");
        INFO_XML_OUT_CHARSET = tmp.getProperty("info.out.charset", "KSC5601");
        if (INFO_SAVE_BASE_URL != null && !INFO_SAVE_BASE_URL.trim().equals("")) {
            String xmlDtd = FileElement.getFileBody(INFO_DTD_LOCATION);
            int i = INFO_DTD_LOCATION.lastIndexOf("/");
            int j = INFO_DTD_LOCATION.lastIndexOf("\\");
            String xmlDtdFileOnlyName = INFO_DTD_LOCATION.substring(Math.max(i, j) + 1);
            FileElement.toFile(INFO_SAVE_BASE_DIR + File.separator + xmlDtdFileOnlyName, xmlDtd);
            SpoolInfo.setDTDLocation(INFO_SAVE_BASE_URL + "/" + xmlDtdFileOnlyName);
        } else {
            SpoolInfo.setDTDLocation(INFO_DTD_LOCATION);
        }
        SpoolInfo.setEncoding(INFO_XML_CHARSET);
        SpoolInfo.setFileEncoding(INFO_XML_OUT_CHARSET);
        if (INFO_SAVE_BASE_DIR == null) {
            throw new RuntimeException("SpoolBaseDirectory  parameter is not set!!!");
        }
    }

    public static synchronized void destroy() throws Exception {
        SPOOL_INFO_HASH.clear();
        PARALLEL_SVR_SPOOLINFO.clear();
    }

    private SpoolInfoManager() {
        super(60000L);
        SPOOL_INFO_HASH = new Hashtable();
        PARALLEL_SVR_SPOOLINFO = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() throws Exception {
        Enumeration ENUM = SPOOL_INFO_HASH.elements();
        SpoolInfo tmpInfo = null;
        if (log.isDebugEnabled()) {
            log.debug("SpoolInfoManager Scan start...");
        }
        while (ENUM.hasMoreElements()) {
            tmpInfo = (SpoolInfo)ENUM.nextElement();
            if (!tmpInfo.expire()) continue;
            Object object = lock;
            synchronized (object) {
                log.info(tmpInfo.getID() + " is removed from SpoolManager");
                SPOOL_INFO_HASH.remove(tmpInfo.getID());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("SpoolInfoManager Scan end...");
        }
    }

    public static synchronized void registSpoolInfo(SpoolInfo spool) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(spool.getID()).append("_").append(spool.getSendState());
        sb.append("_").append(spool.getSpoolDivideScheduleSeq());
        SpoolInfoManager.registSpoolInfo(spool, sb.toString());
    }

    public static synchronized void registSpoolInfo(SpoolInfo spool, String file_name) throws Exception {
        boolean fileDel;
        String store_file_name = FileElement.CheckSubDirectory(INFO_SAVE_BASE_DIR, spool.getID().substring(0, 8)) + "/";
        file_name = file_name + INFO_SAVE_FILE_EXT;
        File __OUT_FILE__ = new File(store_file_name + file_name);
        if (__OUT_FILE__.exists() && !(fileDel = __OUT_FILE__.delete())) {
            log.error("File deletion failed");
        }
        SpoolInfo.toXmlFile(store_file_name + file_name, spool);
        SpoolInfo returnValue = SpoolInfo.XmlToSpoolInfo(store_file_name + file_name);
        String path = store_file_name + file_name;
        if (INFO_SAVE_BASE_URL != null) {
            int i = INFO_SAVE_BASE_DIR.length();
            path = INFO_SAVE_BASE_URL + store_file_name.substring(i) + file_name;
        }
        returnValue.setSpoolInfoPath(path);
        SpoolInfo.toXmlFile(store_file_name + "copy_" + file_name, returnValue);
        SpoolInfoManager.putSpoolInfo(returnValue, false);
        log.info(spool.getID() + " is registered in SpoolManager");
    }

    public static synchronized void registParallelSpoolInfo(SpoolInfo spool, String curSvrName) throws Exception {
        boolean fileDel;
        String file_name = spool.getID() + "_" + spool.getSendState() + "_" + curSvrName;
        String store_file_name = FileElement.CheckSubDirectory(INFO_SAVE_BASE_DIR, spool.getID().substring(0, 8)) + "/";
        file_name = file_name + INFO_SAVE_FILE_EXT;
        File __OUT_FILE__ = new File(store_file_name + file_name);
        if (__OUT_FILE__.exists() && !(fileDel = __OUT_FILE__.delete())) {
            log.error("File deletion failed");
        }
        SpoolInfo.toXmlParallelFile(store_file_name + file_name, spool, curSvrName);
        SpoolInfo returnValue = SpoolInfo.XmlToSpoolInfo(store_file_name + file_name);
        String path = store_file_name + file_name;
        if (INFO_SAVE_BASE_URL != null) {
            int i = INFO_SAVE_BASE_DIR.length();
            path = INFO_SAVE_BASE_URL + store_file_name.substring(i) + file_name;
        }
        returnValue.setSpoolInfoPath(path);
        PARALLEL_SVR_SPOOLINFO.put(spool.getID() + "|" + curSvrName, path);
        SpoolInfo.toXmlFile(store_file_name + "copy_" + file_name, returnValue);
        SpoolInfoManager.putSpoolInfo(returnValue, false);
        log.info(spool.getID() + " is registered in SpoolManager");
    }

    public static synchronized void registTestSpoolInfo(SpoolInfo spool) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("REGISTRATION ID => " + spool.getID());
        }
        SpoolInfoManager.putSpoolInfo(spool, false);
        log.info(spool.getID() + " is registered in SpoolManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void putSpoolInfo(SpoolInfo spool, boolean check) throws Exception {
        spool.execute();
        Object object = lock;
        synchronized (object) {
            if (check && SPOOL_INFO_HASH.containsKey(spool.getID())) {
                return;
            }
            SPOOL_INFO_HASH.put(spool.getID(), spool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpoolInfo getSpoolInfo(String key) throws Exception {
        if (key == null || key.length() < 2) {
            log.error(INNER_MANAGER.getName(), (Object)"INVALID KEY[".concat(key).concat("]"));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(INNER_MANAGER.getName(), (Object)("REQUEST ID => " + key));
        }
        if (log.isDebugEnabled()) {
            log.debug(INNER_MANAGER.getName(), (Object)("CHECK ID => " + key));
        }
        if (SPOOL_INFO_HASH.containsKey(key)) {
            if (log.isDebugEnabled()) {
                log.debug(INNER_MANAGER.getName(), (Object)("ALREADY CONTAIN => " + key));
            }
            SpoolInfo returnValue = (SpoolInfo)SPOOL_INFO_HASH.get(key);
            returnValue.execute();
            return returnValue;
        }
        String scan_file_name = null;
        try {
            File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("spool.info.save.dir"), key.substring(0, 8)));
            String[] fNames = f.list();
            for (int u = 0; u < fNames.length; ++u) {
                if (!fNames[u].startsWith(key + "_") && !fNames[u].startsWith(key + ".") || !fNames[u].endsWith(".xml")) continue;
                scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("spool.info.save.dir"), key.substring(0, 8)) + File.separator + fNames[u];
                break;
            }
        }
        catch (Exception ex) {
            return null;
        }
        if (scan_file_name == null) {
            return null;
        }
        File tmpFile = new File(scan_file_name);
        if (tmpFile.exists()) {
            SpoolInfo returnValue = SpoolInfo.XmlToSpoolInfo(scan_file_name);
            Object object = lock;
            synchronized (object) {
                SPOOL_INFO_HASH.put(key, returnValue);
            }
            returnValue.execute();
            return returnValue;
        }
        log.info(INNER_MANAGER.getName(), (Object)"SCAN FILE NOT EXISTS SO RETURN NULL...");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSpoolInfo(String key) {
        block13: {
            Object object = lock;
            synchronized (object) {
                if (SPOOL_INFO_HASH.containsKey(key)) {
                    return true;
                }
            }
            try {
                String scan_file_name = null;
                boolean exist = false;
                try {
                    File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("spool.info.save.dir"), key.substring(0, 8)));
                    String[] fNames = f.list();
                    for (int u = 0; u < fNames.length; ++u) {
                        if (!fNames[u].startsWith(key + "_") && !fNames[u].startsWith(key + ".") || !fNames[u].endsWith(".xml")) continue;
                        scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("spool.info.save.dir"), key.substring(0, 8)) + File.separator + fNames[u];
                        exist = true;
                        break;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                if (!exist) break block13;
                SpoolInfo returnValue = SpoolInfo.XmlToSpoolInfo(scan_file_name);
                Object object2 = lock;
                synchronized (object2) {
                    SPOOL_INFO_HASH.put(key, returnValue);
                }
                returnValue.execute();
                return true;
            }
            catch (Exception e) {
                log.error("SpoolInfoManager", (Throwable)e);
            }
        }
        return false;
    }

    public static String getParallelSvrSpoolInfo(String key) {
        return (String)PARALLEL_SVR_SPOOLINFO.get(key);
    }

    public static void setParallelSvrSpoolInfo(String key, String path) {
        PARALLEL_SVR_SPOOLINFO.put(key, path);
    }

    public static void main(String[] args) throws Exception {
        SpoolInfoManager sm = new SpoolInfoManager();
        Properties prop = new Properties();
        prop.setProperty("base.dir", "C://asbc/spool_infos");
        prop.setProperty("file.ext", ".xml");
        prop.setProperty("dtd.location", "../../../../conf/venus_spoolinfo.dtd");
        prop.setProperty("info.xml.charset", "UTF-8");
        prop.setProperty("info.out.charset", "UTF-8");
        SpoolInfoManager.init(prop);
    }

    static {
        INNER_MANAGER = new SpoolInfoManager();
        INNER_MANAGER.start();
    }
}

