/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pluto.io.eMsFileWriter;

public class XMLWriter {
    private static final Logger log = LoggerFactory.getLogger(XMLWriter.class);
    private static final String __TAB = "\t";
    private static final String __TAG_OPEN = "<";
    private static final String __END_TAG_OPEN = "</";
    private static final String __TAG_CLOSE = ">";
    private static final String __NO_CHILD_TAG_CLOSE = "/>";
    private static final String __ATTR_OPEN = "=\"";
    private static final String __ATTR_CLOSE = "\"";
    private static final String __BLANK = " ";
    private static final String __PROCESSING_INSTRUCTION_NODE_OPEN = "<?";
    private static final String __PROCESSING_INSTRUCTION_NODE_CLOSE = "?>";
    private static final String __N_PERCENT = "&";
    private static final String __SEMICOLON = ";";
    private static final String __CDATA_OPEN = "<![CDATA[";
    private static final String __CDATA_CLOSE = "]]>";
    private String PRINTWRITER_ENCODING = "euc-kr";
    private boolean canonical = false;
    private eMsFileWriter WRITER = null;
    private String DTDFile = null;
    private StringBuffer __INNER_WORK_BUFFER = new StringBuffer(256);

    public void outResult(eMsFileWriter __STREAM, Document myDoc, String df) throws Exception {
        this.DTDFile = df;
        this.WRITER = __STREAM;
        this.WRITER.println("<?xml version=\"1.0\" encoding=\"" + this.getWriterEncoding() + "\"?>");
        Node node = myDoc.getFirstChild();
        if (node.getNodeType() == 1) {
            this.WRITER.println("<!DOCTYPE " + ((Element)node).getTagName() + " SYSTEM \"" + this.DTDFile + "\">");
        }
        this.print(myDoc, 0);
    }

    public void setEncoding(String enc) {
        this.PRINTWRITER_ENCODING = enc;
    }

    public void setCanonical(boolean can) {
        this.canonical = can;
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        return array;
    }

    private void print(Node node, int depth) throws Exception {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        boolean __HAS_CHILD__ = false;
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int iChild = 0; iChild < children.getLength(); ++iChild) {
                    this.print(children.item(iChild), depth);
                }
                break;
            }
            case 10: {
                this.WRITER.println("<!DOCTYPE " + ((DocumentType)node).getName() + " SYSTEM \"" + this.DTDFile + "\">");
                break;
            }
            case 1: {
                for (int k = 0; k < depth; ++k) {
                    this.WRITER.print(__TAB);
                }
                this.WRITER.print(__TAG_OPEN);
                this.WRITER.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.WRITER.print(__BLANK);
                    this.WRITER.print(attr.getNodeName());
                    this.WRITER.print(__ATTR_OPEN);
                    this.WRITER.print(this.normalize(attr.getNodeValue()));
                    this.WRITER.print(__ATTR_CLOSE);
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                if (len > 0) {
                    __HAS_CHILD__ = true;
                    this.WRITER.println(__TAG_CLOSE);
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i), depth + 1);
                    }
                    break;
                }
                __HAS_CHILD__ = false;
                this.WRITER.println(__NO_CHILD_TAG_CLOSE);
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i), depth + 1);
                    }
                    break;
                }
                this.WRITER.print(__N_PERCENT);
                this.WRITER.print(node.getNodeName());
                this.WRITER.print(__SEMICOLON);
                break;
            }
            case 4: {
                for (int k = 0; k < depth; ++k) {
                    this.WRITER.print(__TAB);
                }
                if (this.canonical) {
                    this.WRITER.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.WRITER.print(__CDATA_OPEN);
                if (log.isDebugEnabled()) {
                    log.debug("CDATA:" + node.getNodeValue());
                }
                this.WRITER.print(node.getNodeValue());
                this.WRITER.println(__CDATA_CLOSE);
                break;
            }
            case 3: {
                String nodeValue = node.getNodeValue();
                if (nodeValue.trim().length() == 0) break;
                for (int k = 0; k < depth; ++k) {
                    this.WRITER.print(__TAB);
                }
                this.WRITER.println(this.normalize(nodeValue));
                break;
            }
            case 7: {
                for (int k = 0; k < depth; ++k) {
                    this.WRITER.print(__TAB);
                }
                this.WRITER.print(__PROCESSING_INSTRUCTION_NODE_OPEN);
                this.WRITER.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.WRITER.print(__BLANK);
                    this.WRITER.print(data);
                }
                this.WRITER.println(__PROCESSING_INSTRUCTION_NODE_CLOSE);
                break;
            }
        }
        if (type == 1 && __HAS_CHILD__) {
            for (int k = 0; k < depth; ++k) {
                this.WRITER.print(__TAB);
            }
            this.WRITER.print(__END_TAG_OPEN);
            this.WRITER.print(node.getNodeName());
            this.WRITER.println(__TAG_CLOSE);
        }
        this.WRITER.flush();
    }

    private synchronized String normalize(String s) {
        this.__INNER_WORK_BUFFER.setLength(0);
        int len = s != null ? s.length() : 0;
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    this.__INNER_WORK_BUFFER.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.__INNER_WORK_BUFFER.append("&gt;");
                    continue block8;
                }
                case '&': {
                    this.__INNER_WORK_BUFFER.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    this.__INNER_WORK_BUFFER.append("&quot;");
                    continue block8;
                }
                case '\\': {
                    this.__INNER_WORK_BUFFER.append("\\\\");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        this.__INNER_WORK_BUFFER.append("&#");
                        this.__INNER_WORK_BUFFER.append(Integer.toString(ch));
                        this.__INNER_WORK_BUFFER.append(';');
                        continue block8;
                    }
                }
                default: {
                    this.__INNER_WORK_BUFFER.append(ch);
                }
            }
        }
        return this.__INNER_WORK_BUFFER.toString();
    }

    private String getWriterEncoding() {
        return this.PRINTWRITER_ENCODING;
    }
}

