/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.Name;
import pluto.log.LogChannel;
import pluto.util.FIFOBuffer;
import pluto.util.StringConvertUtil;
import pluto.util.recycle.RecycleBin;
import pluto.util.recycle.Recycleable;

public abstract class ObjectPool
extends Name
implements RecycleBin {
    private static final Logger log = LoggerFactory.getLogger(ObjectPool.class);
    protected FIFOBuffer STACK_OF_BUFFERED_OBJECT = null;
    protected int CAPACITY;
    protected int CREATE_LEVEL = 0;
    protected int NAME_INDEX = 0;
    protected Object LOCK_OF_GET = new Object();
    protected LogChannel LOG_CHANNEL_INSTANCE = null;

    protected ObjectPool() {
        this(10);
    }

    protected ObjectPool(int cap) {
        this.CAPACITY = cap;
        this.STACK_OF_BUFFERED_OBJECT = new FIFOBuffer(cap);
    }

    @Override
    public void setLogger(LogChannel logger) {
        this.LOG_CHANNEL_INSTANCE = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Recycleable getRecycleable() throws Exception {
        Object returnValue = null;
        while (true) {
            if (log.isDebugEnabled()) {
                log.debug("Check IN");
            }
            if ((returnValue = this.STACK_OF_BUFFERED_OBJECT.pop()) != null) {
                Recycleable r = (Recycleable)returnValue;
                if (log.isDebugEnabled()) {
                    log.debug("Pool pop up : " + r.getName());
                }
                return r;
            }
            if (log.isDebugEnabled()) {
                log.debug("NO RECYCLE  level:" + this.CREATE_LEVEL + " size:" + this.STACK_OF_BUFFERED_OBJECT.size() + "  capa " + this.CAPACITY);
            }
            if (this.CREATE_LEVEL < this.CAPACITY) {
                if (log.isDebugEnabled()) {
                    log.debug("TRY CREATE ACTOR");
                }
                try {
                    Recycleable worker = this.create(this.CREATE_LEVEL, this.NAME_INDEX);
                    this.log(worker.getName() + " is create and return =>level:".concat(String.valueOf(this.CREATE_LEVEL)));
                    ++this.CREATE_LEVEL;
                    ++this.NAME_INDEX;
                    return worker;
                }
                catch (Throwable thw) {
                    this.log(StringConvertUtil.exToString(thw));
                    if (thw instanceof Exception) {
                        throw (Exception)thw;
                    }
                    throw new Exception(thw.toString());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("INTO Wait.");
            }
            Object object = this.LOCK_OF_GET;
            synchronized (object) {
                this.LOCK_OF_GET.wait(10000L);
            }
        }
    }

    @Override
    public int getSize() {
        return this.CAPACITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reSize(int size) {
        this.CAPACITY = size;
        this.STACK_OF_BUFFERED_OBJECT.reSize(this.CAPACITY);
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(Recycleable src) {
        if (log.isDebugEnabled()) {
            log.debug(src.getName() + " size:" + this.STACK_OF_BUFFERED_OBJECT.size() + "  capa " + this.CAPACITY);
        }
        if (this.STACK_OF_BUFFERED_OBJECT.contains(src)) {
            if (log.isDebugEnabled()) {
                log.debug(src.getName() + " is already in pool");
            }
            return;
        }
        if (this.STACK_OF_BUFFERED_OBJECT.push(src)) {
            if (log.isDebugEnabled()) {
                log.debug(src.getName() + " is recycled");
            }
            Object object = this.LOCK_OF_GET;
            synchronized (object) {
                this.LOCK_OF_GET.notifyAll();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("No Room for " + src.getName());
            }
            src.setEnd();
        }
    }

    @Override
    public void destroy(Recycleable src) {
        if (log.isDebugEnabled()) {
            log.debug(src.getName() + " is remove");
        }
        --this.CREATE_LEVEL;
        this.STACK_OF_BUFFERED_OBJECT.remove(src);
    }

    protected abstract Recycleable create(int var1, int var2) throws Exception;
}

